/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine.commandrunner;

import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.hilla.engine.commandrunner.CommandNotFoundException;
import com.vaadin.hilla.engine.commandrunner.CommandRunnerException;
import com.vaadin.hilla.engine.commandrunner.Pipe;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

public interface CommandRunner {
    public static final boolean IS_WINDOWS = FrontendUtils.isWindows();

    public String[] testArguments();

    public String[] arguments();

    public Logger getLogger();

    public File currentDirectory();

    public List<String> executables();

    default public void run(Consumer<OutputStream> stdIn) throws CommandRunnerException {
        this.run(stdIn, true);
    }

    default public void run(Consumer<OutputStream> stdIn, boolean stdOut) throws CommandRunnerException {
        if (stdOut) {
            this.run(stdIn, stdOutStream -> new BufferedReader(new InputStreamReader((InputStream)stdOutStream)).lines().forEach(System.out::println), stdErrStream -> new BufferedReader(new InputStreamReader((InputStream)stdErrStream)).lines().forEach(System.err::println));
        } else {
            this.run(stdIn, null, null);
        }
    }

    default public void run(Consumer<OutputStream> stdIn, Consumer<InputStream> stdOut, Consumer<InputStream> stdErr) throws CommandRunnerException {
        List<String> execs = this.executables();
        String executable = execs.stream().filter(this::executeWithTestArguments).findFirst().orElseThrow(() -> new CommandNotFoundException("No valid executable found between " + execs));
        this.getLogger().debug("Running command {}", (Object)executable);
        this.executeCommand(executable, this.arguments(), stdIn, stdOut, stdErr);
    }

    private boolean executeWithTestArguments(String command) {
        try {
            String[] args = this.testArguments();
            this.getLogger().debug("Testing command {} with arguments {}", (Object)command, (Object)args);
            this.executeCommand(command, args, null, null, null);
            return true;
        }
        catch (CommandRunnerException e) {
            this.getLogger().debug("Testing command {} failed", (Object)command, (Object)e);
            return false;
        }
    }

    private void executeCommand(String executable, String[] arguments, Consumer<OutputStream> stdIn, Consumer<InputStream> stdOut, Consumer<InputStream> stdErr) throws CommandRunnerException {
        List<String> commandWithArgs;
        Stream<String> cmdStream = Stream.concat(Stream.of(executable), Arrays.stream(arguments));
        List<String> list = commandWithArgs = IS_WINDOWS ? List.of("cmd.exe", "/c", cmdStream.map(arg -> arg.contains(" ") ? "\"" + arg + "\"" : arg).collect(Collectors.joining(" ", "\"", "\""))) : cmdStream.collect(Collectors.toList());
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("Running command: \"{}\" in directory \"{}\"", (Object)String.join((CharSequence)" ", commandWithArgs), (Object)this.currentDirectory());
        }
        int exitCode = 0;
        try {
            ProcessBuilder processBuilder = this.createProcessBuilder(commandWithArgs);
            Process process = processBuilder.start();
            List<Thread> threads = Stream.of(new Pipe<InputStream>(stdOut, process.getInputStream()), new Pipe<InputStream>(stdErr, process.getErrorStream()), new Pipe<OutputStream>(stdIn, process.getOutputStream())).filter(handler -> handler.consumer() != null).map(handler -> {
                Thread t = new Thread(() -> {
                    try (Object stream = handler.stream();){
                        handler.consumer().accept(stream);
                    }
                    catch (IOException e) {
                        this.getLogger().error("Error while handling stream", (Throwable)e);
                    }
                });
                t.start();
                return t;
            }).toList();
            exitCode = process.waitFor();
            for (Thread thread : threads) {
                thread.join();
            }
        }
        catch (IOException | InterruptedException e) {
            if (e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains("No such file or directory")) {
                throw new CommandNotFoundException("Command or file not found: " + executable, e);
            }
            throw new CommandRunnerException("Failed to execute command: " + executable, e);
        }
        if (exitCode != 0) {
            throw new CommandRunnerException("Command failed with exit code " + exitCode + ": " + executable);
        }
    }

    default public ProcessBuilder createProcessBuilder(List<String> commandWithArgs) {
        ProcessBuilder builder = new ProcessBuilder(commandWithArgs).directory(this.currentDirectory());
        builder.environment().putAll(this.environment());
        return builder;
    }

    default public ProcessHandle.Info getCurrentProcessInfo() {
        return ProcessHandle.current().info();
    }

    private String getCurrentJavaProcessJavaHome() {
        return this.getCurrentProcessInfo().command().map(javaExecPath -> {
            String pathToExclude = IS_WINDOWS ? "\\bin\\java" : "/bin/java";
            return javaExecPath.substring(0, javaExecPath.lastIndexOf(pathToExclude));
        }).orElse(System.getProperty("java.home"));
    }

    default public Map<String, String> environment() {
        return Map.of("JAVA_HOME", this.getCurrentJavaProcessJavaHome());
    }
}

