/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.hilla.engine.AotBrowserCallableFinder;
import com.vaadin.hilla.engine.ConfigurationException;
import com.vaadin.hilla.engine.GeneratorConfiguration;
import com.vaadin.hilla.engine.LookupBrowserCallableFinder;
import com.vaadin.hilla.engine.ParserConfiguration;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineConfiguration {
    private static EngineConfiguration INSTANCE;
    private static final Logger LOGGER;
    public static final String OPEN_API_PATH = "hilla-openapi.json";
    private Set<Path> classpath = Arrays.stream(System.getProperty("java.class.path").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toSet());
    private String groupId;
    private String artifactId;
    private String mainClass;
    private Path buildDir;
    private Path baseDir = Path.of(System.getProperty("user.dir"), new String[0]);
    private List<Path> classesDirs;
    private GeneratorConfiguration generator;
    private Path outputDir;
    private ParserConfiguration parser;
    private BrowserCallableFinder browserCallableFinder;
    private boolean productionMode = false;
    private String nodeCommand = "node";
    private ClassFinder classFinder;

    private EngineConfiguration() {
        this.buildDir = this.baseDir.resolve("target");
        this.generator = new GeneratorConfiguration();
        this.parser = new ParserConfiguration();
        Path legacyFrontendDir = this.baseDir.resolve("frontend");
        this.outputDir = Files.exists(legacyFrontendDir, new LinkOption[0]) ? legacyFrontendDir.resolve("generated") : this.baseDir.resolve("./src/main/frontend/generated/");
    }

    public Set<Path> getClasspath() {
        return this.classpath;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Path getBuildDir() {
        return this.buildDir;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public List<Path> getClassesDirs() {
        return this.classesDirs == null ? List.of(this.buildDir.resolve("classes")) : this.classesDirs;
    }

    public GeneratorConfiguration getGenerator() {
        return this.generator;
    }

    public Path getOutputDir() {
        return this.outputDir;
    }

    public ParserConfiguration getParser() {
        return this.parser;
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    public String getNodeCommand() {
        return this.nodeCommand;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public List<Class<? extends Annotation>> getEndpointAnnotations() {
        return this.parser.getEndpointAnnotations();
    }

    public List<Class<? extends Annotation>> getEndpointExposedAnnotations() {
        return this.parser.getEndpointExposedAnnotations();
    }

    public Path getOpenAPIFile() {
        return this.productionMode ? this.buildDir.resolve("classes").resolve(OPEN_API_PATH) : this.buildDir.resolve(OPEN_API_PATH);
    }

    public BrowserCallableFinder getBrowserCallableFinder() {
        if (this.browserCallableFinder != null) {
            return this.browserCallableFinder;
        }
        return () -> {
            try {
                return AotBrowserCallableFinder.findEndpointClasses(this);
            }
            catch (Exception e) {
                if (this.classFinder != null) {
                    LOGGER.info("AOT-based detection of browser-callable classes failed. Falling back to classpath scan. Enable debug logging for more information.");
                    return LookupBrowserCallableFinder.findEndpointClasses(this.classFinder, this);
                }
                throw new ExecutionFailedException((Throwable)e);
            }
        };
    }

    public static EngineConfiguration getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new EngineConfiguration();
        }
        return INSTANCE;
    }

    public static void setDefault(EngineConfiguration config) {
        INSTANCE = config;
    }

    static {
        LOGGER = LoggerFactory.getLogger(EngineConfiguration.class);
    }

    @FunctionalInterface
    public static interface BrowserCallableFinder {
        public List<Class<?>> findBrowserCallables() throws ExecutionFailedException;
    }

    public static final class Builder {
        private final EngineConfiguration configuration = new EngineConfiguration();

        public Builder() {
            this(EngineConfiguration.getDefault());
        }

        public Builder(EngineConfiguration configuration) {
            this.configuration.baseDir = configuration.baseDir;
            this.configuration.buildDir = configuration.buildDir;
            this.configuration.classesDirs = configuration.classesDirs;
            this.configuration.classpath = configuration.classpath;
            this.configuration.generator = configuration.generator;
            this.configuration.parser = configuration.parser;
            this.configuration.outputDir = configuration.outputDir;
            this.configuration.groupId = configuration.groupId;
            this.configuration.artifactId = configuration.artifactId;
            this.configuration.mainClass = configuration.mainClass;
            this.configuration.browserCallableFinder = configuration.browserCallableFinder;
            this.configuration.productionMode = configuration.productionMode;
            this.configuration.nodeCommand = configuration.nodeCommand;
            this.configuration.classFinder = configuration.classFinder;
            this.configuration.parser.setEndpointAnnotations(configuration.getEndpointAnnotations());
            this.configuration.parser.setEndpointExposedAnnotations(configuration.getEndpointExposedAnnotations());
        }

        public Builder baseDir(Path value) {
            this.configuration.baseDir = value;
            return this;
        }

        public Builder buildDir(String value) {
            return this.buildDir(Path.of(value, new String[0]));
        }

        public Builder buildDir(Path value) {
            this.configuration.buildDir = this.resolve(value);
            return this;
        }

        public Builder classesDirs(List<Path> values) {
            this.configuration.classesDirs = values.stream().map(this::resolve).toList();
            return this;
        }

        public Builder classpath(Collection<String> value) {
            this.configuration.classpath = value.stream().map(x$0 -> Path.of(x$0, new String[0])).map(this::resolve).collect(Collectors.toSet());
            return this;
        }

        public EngineConfiguration build() {
            return this.configuration;
        }

        public Builder generator(GeneratorConfiguration value) {
            this.configuration.generator = value;
            return this;
        }

        public Builder outputDir(String value) {
            return this.outputDir(Path.of(value, new String[0]));
        }

        public Builder outputDir(Path value) {
            this.configuration.outputDir = this.resolve(value);
            return this;
        }

        public Builder parser(ParserConfiguration value) {
            this.configuration.parser = value;
            return this;
        }

        public Builder groupId(String value) {
            this.configuration.groupId = value;
            return this;
        }

        public Builder artifactId(String value) {
            this.configuration.artifactId = value;
            return this;
        }

        public Builder mainClass(String value) {
            this.configuration.mainClass = value;
            return this;
        }

        public Builder browserCallableFinder(BrowserCallableFinder finder) {
            this.configuration.browserCallableFinder = finder;
            return this;
        }

        public Builder productionMode(boolean value) {
            this.configuration.productionMode = value;
            return this;
        }

        public Builder nodeCommand(String value) {
            this.configuration.nodeCommand = value;
            return this;
        }

        public Builder classFinder(ClassFinder value) {
            this.configuration.classFinder = value;
            return this;
        }

        public Builder endpointAnnotations(Class<? extends Annotation> ... value) {
            this.configuration.parser.setEndpointAnnotations(Arrays.asList(value));
            return this;
        }

        public Builder endpointExposedAnnotations(Class<? extends Annotation> ... value) {
            this.configuration.parser.setEndpointExposedAnnotations(Arrays.asList(value));
            return this;
        }

        public Builder withDefaultAnnotations() {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (this.configuration.classpath != null) {
                URL[] urls = (URL[])this.configuration.classpath.stream().map(path -> {
                    try {
                        return path.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new ConfigurationException("Classpath contains invalid elements", e);
                    }
                }).toArray(URL[]::new);
                classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
            }
            try {
                this.configuration.parser.setEndpointAnnotations(List.of(Class.forName("com.vaadin.hilla.BrowserCallable", true, classLoader), Class.forName("com.vaadin.hilla.Endpoint", true, classLoader)));
                this.configuration.parser.setEndpointExposedAnnotations(List.of(Class.forName("com.vaadin.hilla.EndpointExposed", true, classLoader)));
            }
            catch (Throwable t) {
                LOGGER.debug("Default annotations not found. Hilla is probably not in the classpath.");
            }
            return this;
        }

        private Path resolve(Path path) {
            return path.isAbsolute() ? path.normalize() : this.configuration.baseDir.resolve(path).normalize();
        }
    }
}

