/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine;

import com.vaadin.hilla.parser.core.PluginConfiguration;
import com.vaadin.hilla.parser.plugins.backbone.BackbonePlugin;
import com.vaadin.hilla.parser.plugins.model.ModelPlugin;
import com.vaadin.hilla.parser.plugins.nonnull.NonnullPlugin;
import com.vaadin.hilla.parser.plugins.subtypes.SubTypesPlugin;
import com.vaadin.hilla.parser.plugins.transfertypes.TransferTypesPlugin;
import com.vaadin.hilla.parser.utils.ConfigList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class ParserConfiguration {
    private String endpointAnnotation;
    private String endpointExposedAnnotation;
    private String openAPIBasePath;
    private Plugins plugins;
    private List<String> packages;

    public Optional<String> getEndpointAnnotation() {
        return Optional.ofNullable(this.endpointAnnotation);
    }

    public Optional<String> getEndpointExposedAnnotation() {
        return Optional.ofNullable(this.endpointExposedAnnotation);
    }

    public Optional<String> getOpenAPIBasePath() {
        return Optional.ofNullable(this.openAPIBasePath);
    }

    public Optional<Plugins> getPlugins() {
        return Optional.ofNullable(this.plugins);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParserConfiguration that = (ParserConfiguration)o;
        return Objects.equals(this.endpointAnnotation, that.endpointAnnotation) && Objects.equals(this.endpointExposedAnnotation, that.endpointExposedAnnotation) && Objects.equals(this.openAPIBasePath, that.openAPIBasePath) && Objects.equals(this.plugins, that.plugins) && Objects.equals(this.packages, that.packages);
    }

    public int hashCode() {
        return Objects.hash(this.endpointAnnotation, this.endpointExposedAnnotation, this.openAPIBasePath, this.plugins, this.packages);
    }

    public Optional<List<String>> getPackages() {
        return Optional.ofNullable(this.packages);
    }

    void setEndpointAnnotation(String endpointAnnotation) {
        this.endpointAnnotation = endpointAnnotation;
    }

    void setEndpointExposedAnnotation(String endpointExposedAnnotation) {
        this.endpointExposedAnnotation = endpointExposedAnnotation;
    }

    void setOpenAPIBasePath(String openAPIBasePath) {
        this.openAPIBasePath = openAPIBasePath;
    }

    void setPlugins(Plugins plugins) {
        this.plugins = plugins;
    }

    public void setPackages(List<String> packages) {
        this.packages = packages;
    }

    public static class Plugins
    implements ConfigList<Plugin> {
        private final List<Plugin> disable = new ArrayList<Plugin>();
        private final boolean disableAllDefaults;
        private final List<Plugin> use = new ArrayList<Plugin>();

        public Plugins() {
            this.disableAllDefaults = false;
        }

        Plugins(@Nonnull Collection<Plugin> use, @Nonnull Collection<Plugin> disable, boolean disableAllDefaults) {
            this.disable.addAll(disable);
            this.use.addAll(use);
            this.disableAllDefaults = disableAllDefaults;
        }

        public Collection<Plugin> getDisabledOptions() {
            return this.disable;
        }

        public Collection<Plugin> getUsedOptions() {
            return this.use;
        }

        public boolean shouldAllDefaultsBeDisabled() {
            return this.disableAllDefaults;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Plugins plugins = (Plugins)o;
            return this.disableAllDefaults == plugins.disableAllDefaults && Objects.equals(this.disable, plugins.disable) && Objects.equals(this.use, plugins.use);
        }

        public int hashCode() {
            return Objects.hash(this.disable, this.disableAllDefaults, this.use);
        }
    }

    static class PluginsProcessor
    extends ConfigList.Processor<Plugin> {
        private static final List<Plugin> DEFAULTS = List.of(new Plugin(BackbonePlugin.class.getName()), new Plugin(TransferTypesPlugin.class.getName()), new Plugin(NonnullPlugin.class.getName()), new Plugin(SubTypesPlugin.class.getName()), new Plugin(ModelPlugin.class.getName()));

        PluginsProcessor() {
            super(DEFAULTS);
        }
    }

    public static class Plugin {
        private PluginConfiguration configuration;
        private String name;

        public Plugin() {
        }

        Plugin(String name) {
            this.name = name;
        }

        public Plugin(String name, PluginConfiguration configuration) {
            this(name);
            this.configuration = configuration;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plugin)) {
                return false;
            }
            return Objects.equals(this.name, ((Plugin)other).name);
        }

        public PluginConfiguration getConfiguration() {
            return this.configuration;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

