/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.handler;

import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.hilla.EndpointInvocationException;
import com.vaadin.hilla.signals.internal.InternalSignal;
import com.vaadin.hilla.signals.internal.SecureSignalsRegistry;
import jakarta.annotation.Nullable;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

@AnonymousAllowed
@Component
public class SignalsHandler {
    private static final String FEATURE_FLAG_ERROR_MESSAGE = "%n\n***********************************************************************************************************************\n*  The Hilla Fullstack Signals API is currently considered experimental and may change in the future.                 *\n*  To use it you need to explicitly enable it in Copilot, or by adding com.vaadin.experimental.fullstackSignals=true  *\n*    to src/main/resources/vaadin-featureflags.properties.                                                            *\n***********************************************************************************************************************\n%n".stripIndent();
    private final SecureSignalsRegistry registry;

    public SignalsHandler(@Nullable SecureSignalsRegistry registry) {
        this.registry = registry;
    }

    public Flux<JsonNode> subscribe(String providerEndpoint, String providerMethod, String clientSignalId, ObjectNode body) {
        if (this.registry == null) {
            throw new IllegalStateException(String.format(FEATURE_FLAG_ERROR_MESSAGE, new Object[0]));
        }
        try {
            InternalSignal signal = this.registry.get(clientSignalId);
            if (signal != null) {
                return signal.subscribe(clientSignalId).doFinally(event -> this.registry.unsubscribe(clientSignalId));
            }
            this.registry.register(clientSignalId, providerEndpoint, providerMethod, body);
            return this.registry.get(clientSignalId).subscribe(clientSignalId).doFinally(event -> this.registry.unsubscribe(clientSignalId));
        }
        catch (Exception e) {
            return Flux.error((Throwable)e);
        }
    }

    public void update(String clientSignalId, ObjectNode event) throws EndpointInvocationException.EndpointHttpException {
        if (this.registry == null) {
            throw new IllegalStateException(String.format(FEATURE_FLAG_ERROR_MESSAGE, new Object[0]));
        }
        if (this.registry.get(clientSignalId) == null) {
            throw new IllegalStateException(String.format("Signal not found for client signal: %s", clientSignalId));
        }
        this.registry.get(clientSignalId).submit(clientSignalId, event);
    }
}

