/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.crud;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.hilla.EndpointExposed;
import com.vaadin.hilla.crud.CountService;
import com.vaadin.hilla.crud.GetService;
import com.vaadin.hilla.crud.JpaFilterConverter;
import com.vaadin.hilla.crud.ListService;
import com.vaadin.hilla.crud.filter.Filter;
import jakarta.annotation.PostConstruct;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.data.autoconfigure.web.SpringDataWebProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.CrudRepository;

@EndpointExposed
public class ListRepositoryService<T, ID, R extends CrudRepository<T, ID> & JpaSpecificationExecutor<T>>
implements ListService<T>,
GetService<T, ID>,
CountService {
    static final int DEFAULT_PAGE_SIZE_LIMIT = 2000;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    SpringDataWebProperties springDataWebProperties;
    private R repository;
    private final Class<T> entityClass;

    public ListRepositoryService() {
        this.entityClass = this.resolveEntityClass();
    }

    public ListRepositoryService(R repository) {
        this.repository = repository;
        this.entityClass = this.resolveEntityClass();
    }

    @PostConstruct
    private void init() {
        if (this.repository == null) {
            this.repository = this.resolveRepository();
        }
    }

    protected R getRepository() {
        return this.repository;
    }

    @Override
    public List<T> list(Pageable pageable, @Nullable Filter filter) {
        PageRequest limitedPageable = this.limitSize(pageable);
        Specification<T> spec = this.toSpec(filter);
        return ((JpaSpecificationExecutor)this.getRepository()).findAll(spec, (Pageable)limitedPageable).getContent();
    }

    private PageRequest limitSize(Pageable pageable) {
        int maxPageSize = Optional.ofNullable(this.springDataWebProperties).map(SpringDataWebProperties::getPageable).map(SpringDataWebProperties.Pageable::getMaxPageSize).orElse(2000);
        int effectivePageSize = pageable.isPaged() ? Math.min(pageable.getPageSize(), maxPageSize) : maxPageSize;
        return PageRequest.of((int)(pageable.isPaged() ? pageable.getPageNumber() : 0), (int)effectivePageSize, (Sort)pageable.getSort());
    }

    @Override
    public Optional<T> get(ID id) {
        return this.getRepository().findById(id);
    }

    @Override
    public boolean exists(ID id) {
        return this.getRepository().existsById(id);
    }

    @Override
    public long count(@Nullable Filter filter) {
        return ((JpaSpecificationExecutor)this.getRepository()).count(this.toSpec(filter));
    }

    protected Specification<T> toSpec(@Nullable Filter filter) {
        return JpaFilterConverter.toSpec(filter, this.entityClass);
    }

    private R resolveRepository() {
        TypeVariable repositoryTypeParam = ListRepositoryService.class.getTypeParameters()[2];
        Type entityType = GenericTypeReflector.getTypeParameter(this.getClass(), repositoryTypeParam);
        if (entityType == null) {
            throw new IllegalStateException(String.format("Unable to detect the type for the class '%s' in the class '%s'.", repositoryTypeParam, this.getClass()));
        }
        Class repositoryClass = GenericTypeReflector.erase((Type)entityType);
        return (R)((CrudRepository)this.applicationContext.getBean(repositoryClass));
    }

    protected Class<T> resolveEntityClass() {
        TypeVariable entityTypeParam = ListRepositoryService.class.getTypeParameters()[0];
        Type entityType = GenericTypeReflector.getTypeParameter(this.getClass(), entityTypeParam);
        if (entityType == null) {
            throw new IllegalStateException(String.format("Unable to detect the type for the class '%s' in the class '%s'.", entityTypeParam, this.getClass()));
        }
        return GenericTypeReflector.erase((Type)entityType);
    }
}

