/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla;

import org.springframework.http.HttpStatus;

public abstract class EndpointInvocationException
extends Exception {
    public EndpointInvocationException(String errorMessage) {
        super(errorMessage);
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public static abstract class EndpointHttpException
    extends EndpointInvocationException {
        public EndpointHttpException(String message) {
            super(message);
        }

        protected abstract HttpStatus getHttpStatus();

        public final int getHttpStatusCode() {
            switch (this.getHttpStatus().series()) {
                case CLIENT_ERROR: 
                case SERVER_ERROR: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only 4xx and 5xx status codes are allowed");
                }
            }
            return this.getHttpStatus().value();
        }
    }

    public static class EndpointForbiddenException
    extends EndpointHttpException {
        public EndpointForbiddenException(String message) {
            super(message);
        }

        @Override
        public HttpStatus getHttpStatus() {
            return HttpStatus.FORBIDDEN;
        }
    }

    public static class EndpointUnauthorizedException
    extends EndpointHttpException {
        public EndpointUnauthorizedException(String message) {
            super(message);
        }

        @Override
        public HttpStatus getHttpStatus() {
            return HttpStatus.UNAUTHORIZED;
        }
    }

    public static class EndpointInternalException
    extends EndpointHttpException {
        public EndpointInternalException(String message) {
            super(message);
        }

        @Override
        public HttpStatus getHttpStatus() {
            return HttpStatus.INTERNAL_SERVER_ERROR;
        }
    }

    public static class EndpointBadRequestException
    extends EndpointHttpException {
        public EndpointBadRequestException(String message) {
            super(message);
        }

        @Override
        public HttpStatus getHttpStatus() {
            return HttpStatus.BAD_REQUEST;
        }
    }

    @Deprecated(forRemoval=true)
    public static class EndpointAccessDeniedException
    extends EndpointInvocationException {
        public EndpointAccessDeniedException(String message) {
            super(message);
        }
    }

    public static class EndpointNotFoundException
    extends EndpointHttpException {
        public EndpointNotFoundException() {
            super((String)null);
        }

        @Override
        public HttpStatus getHttpStatus() {
            return HttpStatus.NOT_FOUND;
        }
    }
}

