/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals.core.registry;

import com.vaadin.hilla.signals.Signal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignalsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignalsRegistry.class);
    private final Map<UUID, Signal<?>> signals = new WeakHashMap();
    private final Map<String, UUID> clientSignalToSignalMapping = new HashMap<String, UUID>();

    SignalsRegistry() {
    }

    public synchronized void register(String clientSignalId, Signal<?> signal) {
        Objects.requireNonNull(clientSignalId, "Client signal id must not be null");
        Objects.requireNonNull(signal, "Signal must not be null");
        if (!this.signals.containsKey(signal.getId())) {
            this.signals.put(signal.getId(), signal);
        }
        if (!this.clientSignalToSignalMapping.containsKey(clientSignalId)) {
            this.clientSignalToSignalMapping.put(clientSignalId, signal.getId());
        }
        LOGGER.debug("Registered client-signal: {} => signal: {}", (Object)clientSignalId, (Object)signal.getId());
    }

    public synchronized Signal<?> get(String clientSignalId) {
        Objects.requireNonNull(clientSignalId, "Client signal id must not be null");
        UUID signalId = this.clientSignalToSignalMapping.get(clientSignalId);
        if (signalId == null) {
            LOGGER.debug("No associated signal found for client signal id: {}", (Object)clientSignalId);
            return null;
        }
        return this.signals.get(signalId);
    }

    public synchronized Signal<?> getBySignalId(UUID signalId) {
        Objects.requireNonNull(signalId, "Signal id must not be null");
        return this.signals.get(signalId);
    }

    public synchronized boolean contains(String clientSignalId) {
        Objects.requireNonNull(clientSignalId, "Client signal id must not be null");
        if (!this.clientSignalToSignalMapping.containsKey(clientSignalId)) {
            return false;
        }
        UUID signalId = this.clientSignalToSignalMapping.get(clientSignalId);
        if (!this.signals.containsKey(signalId)) {
            throw new IllegalStateException(String.format("A mapping for client Signal exists, but the signal itself is not registered. Client signal id: %s", clientSignalId));
        }
        return true;
    }

    public synchronized void unregister(UUID signalId) {
        Objects.requireNonNull(signalId, "Signal id to remove must not be null");
        this.signals.remove(signalId);
        this.clientSignalToSignalMapping.values().removeIf(signalId::equals);
        LOGGER.debug("Removed signal {}, and the possible mappings between for its associated client signals, too.", (Object)signalId);
    }

    public synchronized void removeClientSignalToSignalMapping(String clientSignalId) {
        Objects.requireNonNull(clientSignalId, "Client signal id to remove must not be null");
        this.clientSignalToSignalMapping.remove(clientSignalId);
        LOGGER.debug("Removed client signal to signal mapping: {}", (Object)clientSignalId);
    }

    public synchronized boolean isEmpty() {
        return this.signals.isEmpty();
    }

    public synchronized int size() {
        return this.signals.size();
    }

    public synchronized int getAllClientSubscriptionsSize() {
        return this.clientSignalToSignalMapping.size();
    }

    public synchronized Set<String> getAllClientSignalIdsFor(UUID signalId) {
        Objects.requireNonNull(signalId, "Signal id must not be null");
        if (!this.signals.containsKey(signalId)) {
            return Set.of();
        }
        return this.clientSignalToSignalMapping.entrySet().stream().filter(entry -> ((UUID)entry.getValue()).equals(signalId)).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }
}

