/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.Signal;
import com.vaadin.hilla.signals.ValueSignal;
import com.vaadin.hilla.signals.core.event.InvalidEventTypeException;
import com.vaadin.hilla.signals.core.event.ListStateEvent;
import com.vaadin.hilla.signals.core.event.MissingFieldException;
import com.vaadin.hilla.signals.core.event.StateEvent;
import com.vaadin.hilla.signals.operation.ListInsertOperation;
import com.vaadin.hilla.signals.operation.ListRemoveOperation;
import com.vaadin.hilla.signals.operation.OperationValidator;
import com.vaadin.hilla.signals.operation.ReplaceValueOperation;
import com.vaadin.hilla.signals.operation.SetValueOperation;
import com.vaadin.hilla.signals.operation.ValidationResult;
import com.vaadin.hilla.signals.operation.ValueOperation;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class ListSignal<T>
extends Signal<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSignal.class);
    private final Map<UUID, Entry<T>> entries = new HashMap<UUID, Entry<T>>();
    private UUID head;
    private UUID tail;

    public ListSignal(Class<T> valueType) {
        super(valueType);
    }

    protected ListSignal(ListSignal<T> delegate) {
        super(delegate);
    }

    @Override
    protected ListSignal<T> getDelegate() {
        return (ListSignal)super.getDelegate();
    }

    @Override
    public Flux<ObjectNode> subscribe(String signalId) {
        if (this.getDelegate() != null) {
            return ((ListSignal)this.getDelegate()).subscribe(signalId);
        }
        Entry<T> signalEntry = this.entries.get(UUID.fromString(signalId));
        return signalEntry.value.subscribe();
    }

    @Override
    public void submit(ObjectNode event) {
        String rawEventType = StateEvent.extractRawEventType((JsonNode)event);
        if (StateEvent.EventType.find(rawEventType).isPresent()) {
            this.submitToChild(event);
        } else {
            super.submit(event);
        }
    }

    protected void submitToChild(ObjectNode event) {
        if (this.getDelegate() != null) {
            ((ListSignal)this.getDelegate()).submitToChild(event);
            return;
        }
        String entryId = StateEvent.extractId((JsonNode)event);
        Entry<T> signalEntry = this.entries.get(UUID.fromString(entryId));
        if (signalEntry == null) {
            LOGGER.debug("Signal entry not found for id: {}. Ignoring the event: {}", (Object)entryId, (Object)event);
            return;
        }
        signalEntry.value.submit(event);
    }

    @Override
    protected ObjectNode createSnapshotEvent() {
        if (this.getDelegate() != null) {
            return ((ListSignal)this.getDelegate()).createSnapshotEvent();
        }
        List entries = this.entries.values().stream().map(entry -> entry).toList();
        ListStateEvent event = new ListStateEvent(this.getId().toString(), ListStateEvent.EventType.SNAPSHOT, entries);
        event.setAccepted(true);
        return event.toJson();
    }

    @Override
    protected ObjectNode processEvent(ObjectNode event) {
        try {
            ListStateEvent stateEvent = new ListStateEvent(event, this.getValueType());
            return switch (stateEvent.getEventType()) {
                case ListStateEvent.EventType.INSERT -> this.handleInsert(stateEvent).toJson();
                case ListStateEvent.EventType.REMOVE -> this.handleRemoval(stateEvent).toJson();
                default -> throw new UnsupportedOperationException("Unsupported event: " + stateEvent.getEventType());
            };
        }
        catch (InvalidEventTypeException e) {
            throw new UnsupportedOperationException("Unsupported JSON: " + event, e);
        }
    }

    protected ListStateEvent<T> handleInsert(ListStateEvent<T> event) {
        if (this.getDelegate() != null) {
            return ((ListSignal)this.getDelegate()).handleInsert(event);
        }
        if (event.getValue() == null) {
            throw new MissingFieldException("value");
        }
        Entry<T> toBeInserted = this.createEntry(event.getValue());
        if (this.entries.containsKey(toBeInserted.id())) {
            LOGGER.warn("Duplicate UUID generation detected when adding a new entry: {}, rejecting the insert event.", (Object)toBeInserted.id());
            event.setAccepted(false);
            return event;
        }
        switch (event.getPosition()) {
            case FIRST: {
                throw new UnsupportedOperationException("Insert first is not supported");
            }
            case BEFORE: {
                throw new UnsupportedOperationException("Insert before is not supported");
            }
            case AFTER: {
                throw new UnsupportedOperationException("Insert after is not supported");
            }
            case LAST: {
                if (this.tail == null) {
                    this.head = this.tail = toBeInserted.id();
                } else {
                    Entry<T> currentTail = this.entries.get(this.tail);
                    currentTail.next = toBeInserted.id();
                    toBeInserted.prev = currentTail.id();
                    this.tail = toBeInserted.id();
                }
                this.entries.put(toBeInserted.id(), toBeInserted);
                event.setEntryId(toBeInserted.id());
                event.setAccepted(true);
                return event;
            }
        }
        return event;
    }

    private Entry<T> createEntry(T value) {
        return new Entry<T>(UUID.randomUUID(), this.createValueSignal(value));
    }

    private ValueSignal<T> createValueSignal(T value) {
        return new ValueSignal<T>(value, this.getValueType());
    }

    protected ListStateEvent<T> handleRemoval(ListStateEvent<T> event) {
        if (this.getDelegate() != null) {
            return ((ListSignal)this.getDelegate()).handleRemoval(event);
        }
        if (event.getEntryId() == null) {
            throw new MissingFieldException("entryId");
        }
        if (this.head == null || this.entries.isEmpty()) {
            event.setAccepted(false);
            return event;
        }
        Entry<T> toBeRemovedEntry = this.entries.get(event.getEntryId());
        if (toBeRemovedEntry == null) {
            event.setAccepted(true);
            return event;
        }
        if (this.head.equals(toBeRemovedEntry.id())) {
            if (toBeRemovedEntry.next() == null) {
                this.tail = null;
                this.head = null;
            } else {
                Entry<T> newHead = this.entries.get(toBeRemovedEntry.next());
                this.head = newHead.id();
                newHead.prev = null;
            }
        } else {
            Entry<T> prev = this.entries.get(toBeRemovedEntry.previous());
            Entry<T> next = this.entries.get(toBeRemovedEntry.next());
            if (next == null) {
                this.tail = prev.id();
                prev.next = null;
            } else {
                prev.next = next.id();
                next.prev = prev.id();
            }
        }
        this.entries.remove(toBeRemovedEntry.id());
        event.setAccepted(true);
        return event;
    }

    protected ListStateEvent.ListEntry<T> getEntry(UUID entryId) {
        return this.entries.get(entryId);
    }

    public ListSignal<T> withOperationValidator(OperationValidator<T> validator) {
        Objects.requireNonNull(validator, "Validator cannot be null");
        return new ValidatedListSignal<T>(this, validator);
    }

    @Override
    public ListSignal<T> asReadonly() {
        return this.withOperationValidator(op -> ValidationResult.reject("Read-only signal does not allow any modifications"));
    }

    private static final class Entry<V>
    implements ListStateEvent.ListEntry<V> {
        private final UUID id;
        private UUID prev;
        private UUID next;
        private final ValueSignal<V> value;

        public Entry(UUID id, @Nullable UUID prev, @Nullable UUID next, ValueSignal<V> valueSignal) {
            this.id = id;
            this.prev = prev;
            this.next = next;
            this.value = valueSignal;
        }

        public Entry(UUID id, ValueSignal<V> valueSignal) {
            this(id, null, null, valueSignal);
        }

        @Override
        public UUID id() {
            return this.id;
        }

        @Override
        public UUID previous() {
            return this.prev;
        }

        @Override
        public UUID next() {
            return this.next;
        }

        @Override
        public V value() {
            return this.value.getValue();
        }

        @Override
        public ValueSignal<V> getValueSignal() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListStateEvent.ListEntry)) {
                return false;
            }
            ListStateEvent.ListEntry entry = (ListStateEvent.ListEntry)o;
            return Objects.equals(this.id, entry.id());
        }

        public int hashCode() {
            return Objects.hashCode(this.id);
        }
    }

    private static class ValidatedListSignal<T>
    extends ListSignal<T> {
        private final OperationValidator<T> operationValidator;

        private ValidatedListSignal(ListSignal<T> delegate, OperationValidator<T> operationValidator) {
            super(delegate);
            this.operationValidator = operationValidator;
        }

        @Override
        protected ListStateEvent<T> handleInsert(ListStateEvent<T> event) {
            ListInsertOperation<T> listInsertOperation = new ListInsertOperation<T>(event.getId(), event.getPosition(), event.getValue());
            ValidationResult validationResult = this.operationValidator.validate(listInsertOperation);
            return this.handleValidationResult(event, validationResult, (ListStateEvent<T> x$0) -> super.handleInsert(x$0));
        }

        @Override
        protected ListStateEvent<T> handleRemoval(ListStateEvent<T> event) {
            if (event.getEntryId() == null) {
                throw new MissingFieldException("entryId");
            }
            ListStateEvent.ListEntry entryToRemove = this.getEntry(event.getEntryId());
            ListRemoveOperation listRemoveOperation = new ListRemoveOperation(event.getId(), entryToRemove);
            ValidationResult validationResult = this.operationValidator.validate(listRemoveOperation);
            return this.handleValidationResult(event, validationResult, (ListStateEvent<T> x$0) -> super.handleRemoval(x$0));
        }

        @Override
        protected void submitToChild(ObjectNode event) {
            if (!StateEvent.isSetEvent(event) && !StateEvent.isReplaceEvent(event)) {
                super.submitToChild(event);
                return;
            }
            ValueOperation<T> valueOperation = this.extractValueOperation(event);
            ValidationResult validationResult = this.operationValidator.validate(valueOperation);
            this.handleValidationResult(event, validationResult, (ObjectNode x$0) -> super.submitToChild((ObjectNode)x$0));
        }

        private ValueOperation<T> extractValueOperation(ObjectNode event) {
            if (StateEvent.isSetEvent(event)) {
                return SetValueOperation.of(event, this.getValueType());
            }
            if (StateEvent.isReplaceEvent(event)) {
                return ReplaceValueOperation.of(event, this.getValueType());
            }
            throw new UnsupportedOperationException("Unsupported event: " + event);
        }

        private ListStateEvent<T> handleValidationResult(ListStateEvent<T> event, ValidationResult validationResult, Function<ListStateEvent<T>, ListStateEvent<T>> handler) {
            if (validationResult.isOk()) {
                return handler.apply(event);
            }
            return this.rejectEvent(event, validationResult);
        }

        private ListStateEvent<T> rejectEvent(ListStateEvent<T> event, ValidationResult result) {
            event.setAccepted(false);
            event.setValidationError(result.getErrorMessage());
            return event;
        }

        private void handleValidationResult(ObjectNode event, ValidationResult validationResult, Consumer<ObjectNode> handler) {
            if (validationResult.isOk()) {
                handler.accept(event);
            } else {
                handler.accept(this.rejectEvent(event, validationResult));
            }
        }

        private ObjectNode rejectEvent(ObjectNode event, ValidationResult result) {
            StateEvent stateEvent = new StateEvent(event, this.getValueType());
            stateEvent.setAccepted(false);
            stateEvent.setValidationError(result.getErrorMessage());
            return stateEvent.toJson();
        }
    }
}

