/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.signals;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.hilla.signals.ValueSignal;
import com.vaadin.hilla.signals.core.event.StateEvent;

public class NumberSignal
extends ValueSignal<Double> {
    public NumberSignal(Double defaultValue) {
        super(defaultValue, Double.class);
    }

    public NumberSignal() {
        this(0.0);
    }

    @Override
    protected boolean processEvent(ObjectNode event) {
        try {
            StateEvent<Double> stateEvent = new StateEvent<Double>(event, Double.class);
            if (!StateEvent.EventType.INCREMENT.equals((Object)stateEvent.getEventType())) {
                return super.processEvent(event);
            }
            Double expectedValue = (Double)this.getValue();
            Double newValue = expectedValue + stateEvent.getValue();
            return super.compareAndSet(newValue, expectedValue);
        }
        catch (StateEvent.InvalidEventTypeException e) {
            throw new UnsupportedOperationException("Unsupported JSON: " + event, e);
        }
    }
}

