/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.route;

import com.vaadin.flow.internal.hilla.FileRouterRequestUtil;
import com.vaadin.hilla.route.ClientRouteRegistry;
import com.vaadin.hilla.route.records.ClientViewConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.RequestPath;
import org.springframework.stereotype.Component;

@Component
public class RouteUtil
implements FileRouterRequestUtil {
    private final ClientRouteRegistry registry;

    @Autowired
    public RouteUtil(ClientRouteRegistry registry) {
        this.registry = registry;
    }

    public boolean isRouteAllowed(HttpServletRequest request) {
        Optional<ClientViewConfig> viewConfig = this.getRouteData(request);
        boolean isUserAuthenticated = request.getUserPrincipal() != null;
        return viewConfig.filter(clientViewConfig -> this.isRouteAllowed(arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0), isUserAuthenticated, (ClientViewConfig)clientViewConfig)).isPresent();
    }

    boolean isRouteAllowed(Predicate<? super String> isUserInRole, boolean isUserAuthenticated, ClientViewConfig viewConfig) {
        String[] rolesAllowed;
        boolean isAllowed = viewConfig.isLoginRequired() && !isUserAuthenticated ? false : ((rolesAllowed = viewConfig.getRolesAllowed()) != null ? Arrays.stream(rolesAllowed).anyMatch(isUserInRole) : true);
        if (isAllowed && viewConfig.getParent() != null) {
            isAllowed = this.isRouteAllowed(isUserInRole, isUserAuthenticated, viewConfig.getParent());
        }
        return isAllowed;
    }

    private Optional<ClientViewConfig> getRouteData(HttpServletRequest request) {
        RequestPath requestPath = RequestPath.parse((String)request.getRequestURI(), (String)request.getContextPath());
        return Optional.ofNullable(this.registry.getRouteByPath(requestPath.pathWithinApplication().value()));
    }
}

