/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.fusion.generator;

import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VaadinConnectClientGenerator {
    static final String PREFIX = "vaadin.endpoint.prefix";
    static final String DEFAULT_PREFIX = "/connect";
    static final String URL_MAPPING = "vaadin.urlMapping";
    static final String DEFAULT_URL_MAPPING = "/*";
    private static final String CLIENT_FILE_NAME = "connect-client.default";
    public static final String CONNECT_CLIENT_NAME = "connect-client.default.ts";
    private static final String CUSTOM_CLIENT_FILE_NAME = "connect-client";
    public static final String CUSTOM_CONNECT_CLIENT_NAME = "connect-client.ts";
    public static final String CONNECT_CLIENT_IMPORT_PATH = "./connect-client.default";
    private final String endpointPrefix;
    private static final Logger log = LoggerFactory.getLogger(VaadinConnectClientGenerator.class);

    public VaadinConnectClientGenerator(Properties applicationProperties) {
        String prefix = (String)applicationProperties.getOrDefault((Object)PREFIX, DEFAULT_PREFIX);
        String urlMapping = (String)applicationProperties.getOrDefault((Object)URL_MAPPING, DEFAULT_URL_MAPPING);
        this.endpointPrefix = this.relativizeEndpointPrefixWithUrlMapping(prefix, urlMapping);
    }

    final String relativizeEndpointPrefixWithUrlMapping(String endpointPrefix, String urlMapping) {
        urlMapping = this.removeTrailingStar(urlMapping);
        endpointPrefix = this.removeTrailingStar(endpointPrefix);
        Path urlMappingPath = Paths.get(urlMapping, new String[0]).normalize();
        Path endpointPrefixPath = Paths.get(endpointPrefix, new String[0]).normalize();
        return FrontendUtils.getUnixRelativePath((Path)urlMappingPath, (Path)endpointPrefixPath);
    }

    private String removeTrailingStar(String original) {
        if (original != null && original.endsWith(DEFAULT_URL_MAPPING)) {
            return original.substring(0, original.length() - 1);
        }
        return original;
    }

    public void generateVaadinConnectClientFile(Path outputFilePath) {
        String generatedDefaultClientTs = this.getDefaultClientTsTemplate().replace("{{PREFIX}}", this.endpointPrefix);
        try {
            log.info("writing file {}", (Object)outputFilePath);
            FileUtils.writeStringToFile((File)outputFilePath.toFile(), (String)generatedDefaultClientTs, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String errorMessage = String.format("Error writing file at %s", outputFilePath.toString());
            log.error(errorMessage, (Object)outputFilePath, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDefaultClientTsTemplate() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("connect-client.default.ts.template"), StandardCharsets.UTF_8));){
            String string = bufferedReader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read connect-client.default.ts.template", e);
        }
    }
}

