/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.connect.generator;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.declarations.ResolvedEnumConstantDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedFieldDeclaration;
import com.github.javaparser.resolution.types.ResolvedReferenceType;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.server.connect.generator.GeneratorUtils;
import com.vaadin.flow.server.connect.generator.OpenApiObjectGenerator;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaGenerator {
    private final OpenApiObjectGenerator openApiObjectGenerator;

    SchemaGenerator(OpenApiObjectGenerator openApiObjectGenerator) {
        this.openApiObjectGenerator = openApiObjectGenerator;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SchemaGenerator.class);
    }

    Schema createSingleSchema(String fullQualifiedName, TypeDeclaration<?> typeDeclaration) {
        Optional<String> description = typeDeclaration.getJavadoc().map(javadoc -> javadoc.getDescription().toText());
        ObjectSchema schema = new ObjectSchema();
        schema.setName(fullQualifiedName);
        description.ifPresent(arg_0 -> ((Schema)schema).setDescription(arg_0));
        Map<String, Schema> properties = this.getPropertiesFromClassDeclaration(typeDeclaration);
        schema.properties(properties);
        List requiredList = properties.entrySet().stream().filter(stringSchemaEntry -> GeneratorUtils.isNotTrue(((Schema)stringSchemaEntry.getValue()).getNullable())).map(Map.Entry::getKey).collect(Collectors.toList());
        properties.values().forEach(propertySchema -> propertySchema.nullable(null));
        schema.setRequired(requiredList);
        return schema;
    }

    Schema parseTypeToSchema(Type javaType, String description) {
        try {
            Schema schema = this.openApiObjectGenerator.parseResolvedTypeToSchema(javaType.resolve());
            if (GeneratorUtils.isNotBlank(description)) {
                schema.setDescription(description);
            }
            return schema;
        }
        catch (Exception e) {
            SchemaGenerator.getLogger().info(String.format("Can't resolve type '%s' for creating custom OpenAPI Schema. Using the default ObjectSchema instead.", javaType.asString()), (Throwable)e);
            return new ObjectSchema();
        }
    }

    Schema createSingleSchemaFromResolvedType(ResolvedReferenceType resolvedType) {
        if (resolvedType.getTypeDeclaration().isEnum()) {
            List entries = resolvedType.getTypeDeclaration().asEnum().getEnumConstants().stream().map(ResolvedEnumConstantDeclaration::getName).collect(Collectors.toList());
            StringSchema schema = new StringSchema();
            schema.name(resolvedType.getQualifiedName());
            schema.setEnum(entries);
            return schema;
        }
        Schema schema = new ObjectSchema().name(resolvedType.getQualifiedName());
        Map<String, Boolean> fieldsOptionalMap = this.getFieldsAndOptionalMap(resolvedType);
        Set serializableFields = resolvedType.getDeclaredFields().stream().filter(resolvedFieldDeclaration -> fieldsOptionalMap.containsKey(resolvedFieldDeclaration.getName())).collect(Collectors.toSet());
        schema.setProperties(new TreeMap());
        for (ResolvedFieldDeclaration resolvedFieldDeclaration2 : serializableFields) {
            String name = resolvedFieldDeclaration2.getName();
            Schema type = this.openApiObjectGenerator.parseResolvedTypeToSchema(resolvedFieldDeclaration2.getType());
            if (!fieldsOptionalMap.get(name).booleanValue()) {
                schema.addRequiredItem(name);
            }
            schema.addProperties(name, type);
        }
        return schema;
    }

    private Map<String, Boolean> getFieldsAndOptionalMap(ResolvedReferenceType resolvedType) {
        if (!resolvedType.getTypeDeclaration().isClass() || resolvedType.getTypeDeclaration().isAnonymousClass()) {
            return Collections.emptyMap();
        }
        HashMap<String, Boolean> validFields = new HashMap<String, Boolean>();
        try {
            Class<?> aClass = this.openApiObjectGenerator.getClassFromReflection(resolvedType);
            Arrays.stream(aClass.getDeclaredFields()).filter(field -> {
                int modifiers = field.getModifiers();
                return !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.isAnnotationPresent(JsonIgnore.class);
            }).forEach(field -> validFields.put(field.getName(), field.isAnnotationPresent(Nullable.class) || ReflectTools.hasAnnotationWithSimpleName((AnnotatedElement)field, (String)"Id") || field.getType().equals(Optional.class)));
        }
        catch (ClassNotFoundException e) {
            String message = String.format("Can't get list of fields from class '%s'.Please make sure that class '%s' is in your project's compile classpath. As the result, the generated TypeScript file will be empty.", resolvedType.getQualifiedName(), resolvedType.getQualifiedName());
            SchemaGenerator.getLogger().info(message);
            SchemaGenerator.getLogger().debug(message, (Throwable)e);
        }
        return validFields;
    }

    private Map<String, Schema> getPropertiesFromClassDeclaration(TypeDeclaration<?> typeDeclaration) {
        TreeMap<String, Schema> properties = new TreeMap<String, Schema>();
        for (FieldDeclaration field : typeDeclaration.getFields()) {
            if (field.isTransient() || field.isStatic() || field.isAnnotationPresent(JsonIgnore.class)) continue;
            Optional<String> fieldDescription = field.getJavadoc().map(javadoc -> javadoc.getDescription().toText());
            field.getVariables().forEach(variableDeclarator -> {
                Schema propertySchema = this.parseTypeToSchema(variableDeclarator.getType(), fieldDescription.orElse(""));
                if (GeneratorUtils.isNotBlank(propertySchema.get$ref())) {
                    ComposedSchema wrapperSchema = new ComposedSchema();
                    wrapperSchema.name(propertySchema.getName());
                    wrapperSchema.addAllOfItem(propertySchema);
                    propertySchema = wrapperSchema;
                }
                if (field.isAnnotationPresent(Nullable.class) || field.isAnnotationPresent("Id") || GeneratorUtils.isTrue(propertySchema.getNullable())) {
                    propertySchema.setNullable(Boolean.valueOf(true));
                }
                this.addFieldAnnotationsToSchema(field, propertySchema);
                properties.put(variableDeclarator.getNameAsString(), propertySchema);
            });
        }
        return properties;
    }

    private void addFieldAnnotationsToSchema(FieldDeclaration field, Schema<?> schema) {
        LinkedHashSet annotations = new LinkedHashSet();
        field.getAnnotations().stream().forEach(annotation -> {
            String str = annotation.toString().replaceFirst("@", "").replace(" = ", ":");
            if (str.contains(":")) {
                str = str.replaceFirst("\\(", "({").replaceFirst("\\)$", "})");
            }
            if ((str = str + (str.contains("(") ? "" : "()")).matches("(Email|Null|NotNull|NotEmpty|NotBlank|AssertTrue|AssertFalse|Negative|NegativeOrZero|Positive|PositiveOrZero|Size|Past|Future|Digits|Min|Max|Pattern|DecimalMin|DecimalMax)\\(.+")) {
                annotations.add(str);
            }
        });
        if (!annotations.isEmpty()) {
            schema.addExtension("x-annotations", annotations.stream().sorted((a, b) -> this.isAnnotationIndicatingRequired((String)a) ? -1 : (this.isAnnotationIndicatingRequired((String)b) ? 1 : a.compareTo((String)b))).collect(Collectors.toList()));
        }
    }

    private boolean isAnnotationIndicatingRequired(String str) {
        return str.matches("(NonNull|NotNull|NotEmpty|NotBlank)\\(.+") || str.matches("Size\\(\\{.*min:[^0].+");
    }
}

