/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testutil.LocalExecution;
import com.vaadin.flow.testutil.TestBenchHelpers;
import com.vaadin.testbench.TestBenchTestCase;
import com.vaadin.testbench.annotations.BrowserConfiguration;
import com.vaadin.testbench.annotations.BrowserFactory;
import com.vaadin.testbench.annotations.RunOnHub;
import com.vaadin.testbench.parallel.Browser;
import com.vaadin.testbench.parallel.DefaultBrowserFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

@RunOnHub
@BrowserFactory(value=DefaultBrowserFactory.class)
@LocalExecution
public abstract class AbstractTestBenchTest
extends TestBenchHelpers {
    private static final String DEFAULT_SERVER_PORT = "8888";
    public static final String SERVER_PORT_PROPERTY_KEY = "serverPort";
    public static final int SERVER_PORT = Integer.parseInt(System.getProperty("serverPort", "8888"));
    public static final String USE_HUB_PROPERTY = "test.use.hub";
    public static final boolean USE_HUB = Boolean.TRUE.toString().equals(System.getProperty("test.use.hub", "false"));
    public static final String USE_BROWSERSTACK_PROPERTY = "test.use.browserstack";
    public static final boolean USE_BROWSERSTACK = Boolean.TRUE.toString().equals(System.getProperty("test.use.browserstack", "false"));
    public static final String BROWSERSTACK_IDENTIFIER_PROPERTY = "test.browserstack.identifier";
    public static final String BROWSERSTACK_IDENTIFIER = System.getProperty("test.browserstack.identifier", "");
    private boolean serverAvailabilityChecked;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void checkIfServerAvailable() {
        if (!this.serverAvailabilityChecked) {
            String rootUrl = this.getRootURL();
            try {
                new URL(rootUrl).openConnection().connect();
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not connect to %s please check that you have a web server started.", rootUrl), e);
            }
            this.serverAvailabilityChecked = true;
        }
    }

    protected void open() {
        this.open(null);
    }

    protected void open(String ... parameters) {
        String url = this.getTestURL(parameters);
        this.getDriver().get(url);
        this.waitForDevServer();
    }

    protected void openProduction(String ... parameters) {
        this.openUrl("view-production", parameters);
    }

    protected void openProductionWithTiming(String ... parameters) {
        this.openUrl("view-production-timing", parameters);
    }

    protected void openForEs6Url(String ... parameters) {
        this.openUrl("view-es6-url", parameters);
    }

    protected void openUrl(String targetUrl, String ... parameters) {
        String url = this.getTestURL(parameters);
        if (!url.contains("/view/")) {
            throw new IllegalArgumentException("Custom url mode (" + targetUrl + ") is only available for /view/ URLs");
        }
        StringBuilder builder = new StringBuilder(targetUrl);
        if (!targetUrl.startsWith("/")) {
            builder.insert(0, "/");
        }
        if (!targetUrl.endsWith("/")) {
            builder.append("/");
        }
        url = url.replace("/view/", builder.toString());
        this.getDriver().get(url);
        this.waitForDevServer();
    }

    protected final boolean isClientRouter() {
        return ClientChecker.isClientRouter((TestBenchTestCase)this);
    }

    protected void waitForClientRouter() {
        if (this.isClientRouter()) {
            this.waitForElementPresent(By.cssSelector((String)"#outlet > *"));
        }
    }

    protected String getTestURL(String ... parameters) {
        return AbstractTestBenchTest.getTestURL(this.getRootURL(), this.getTestPath(), parameters);
    }

    protected abstract String getTestPath();

    protected String getRootURL() {
        return "http://" + this.getDeploymentHostname() + ":" + this.getDeploymentPort();
    }

    protected void verifyScreenshot(String identifier) throws IOException {
        Assert.assertTrue((String)("SCREENSHOT MATCH FAILURE: <" + identifier + "> does not match expected."), (boolean)this.testBench().compareScreen(identifier));
    }

    @BrowserConfiguration
    public List<DesiredCapabilities> getBrowsersToTest() {
        if (this.getLocalExecution().isPresent()) {
            return this.getBrowserCapabilities(this.getLocalExecution().get().value());
        }
        return this.getHubBrowsersToTest();
    }

    protected List<DesiredCapabilities> getHubBrowsersToTest() {
        return this.getBrowserCapabilities(Browser.FIREFOX, Browser.CHROME);
    }

    protected List<DesiredCapabilities> getBrowserCapabilities(Browser ... browsers) {
        ArrayList<DesiredCapabilities> capabilities = new ArrayList<DesiredCapabilities>();
        for (Browser browser : browsers) {
            DesiredCapabilities caps = browser.getDesiredCapabilities();
            if (USE_BROWSERSTACK) {
                caps.setCapability("os", "Windows");
                caps.setCapability("os_version", "7");
                caps.setPlatform(Platform.WINDOWS);
                if (!BROWSERSTACK_IDENTIFIER.isEmpty()) {
                    caps.setCapability("browserstack.localIdentifier", BROWSERSTACK_IDENTIFIER);
                }
                caps.setCapability("build", "BrowserStack Tests" + (String)(BROWSERSTACK_IDENTIFIER.isEmpty() ? "" : " [" + BROWSERSTACK_IDENTIFIER + "]"));
                caps.setCapability("acceptSslCerts", "true");
                caps.setCapability("resolution", "1680x1050");
            }
            capabilities.add(caps);
        }
        return capabilities;
    }

    protected String getDeploymentHostname() {
        if (this.getLocalExecution().isPresent()) {
            return "localhost";
        }
        return this.getCurrentHostAddress();
    }

    protected String getCurrentHostAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Optional<String> address;
                NetworkInterface nwInterface = interfaces.nextElement();
                if (!nwInterface.isUp() || nwInterface.isLoopback() || nwInterface.isVirtual() || !(address = AbstractTestBenchTest.getHostAddress(nwInterface)).isPresent()) continue;
                return address.get();
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("Could not find the host name", e);
        }
        throw new RuntimeException("No compatible (10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) ip address found.");
    }

    protected int getDeploymentPort() {
        return SERVER_PORT;
    }

    protected String getHubHostname() {
        if (this.getLocalExecution().isPresent()) {
            return "localhost";
        }
        return super.getHubHostname();
    }

    protected Browser getRunLocallyBrowser() {
        if (this.getLocalExecution().isPresent()) {
            return this.getLocalExecution().get().value();
        }
        return super.getRunLocallyBrowser();
    }

    protected String getRunLocallyBrowserVersion() {
        if (this.getLocalExecution().isPresent()) {
            return this.getLocalExecution().get().browserVersion();
        }
        return super.getRunLocallyBrowserVersion();
    }

    protected Optional<LocalExecution> getLocalExecution() {
        if (USE_HUB) {
            return Optional.empty();
        }
        return Optional.ofNullable(((Object)((Object)this)).getClass().getAnnotation(LocalExecution.class)).filter(LocalExecution::active);
    }

    private static Optional<String> getHostAddress(NetworkInterface nwInterface) {
        Enumeration<InetAddress> addresses = nwInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (address.isLoopbackAddress() || !address.isSiteLocalAddress()) continue;
            return Optional.of(address.getHostAddress());
        }
        return Optional.empty();
    }

    public static String getTestURL(String rootUrl, String testPath, String ... parameters) {
        while (((String)rootUrl).endsWith("/")) {
            rootUrl = ((String)rootUrl).substring(0, ((String)rootUrl).length() - 1);
        }
        rootUrl = (String)rootUrl + testPath;
        if (parameters != null && parameters.length != 0) {
            rootUrl = !((String)rootUrl).contains("?") ? (String)rootUrl + "?" : (String)rootUrl + "&";
            rootUrl = (String)rootUrl + Arrays.stream(parameters).collect(Collectors.joining("&"));
        }
        return rootUrl;
    }

    public static abstract class ClientChecker {
        private static Boolean hasClientRouter;

        private static boolean isClientRouter(TestBenchTestCase test) {
            if (hasClientRouter == null) {
                hasClientRouter = (boolean)((Boolean)((JavascriptExecutor)test.getDriver()).executeScript("return !!window.Vaadin.Flow.clients.TypeScript", new Object[0]));
            }
            return hasClientRouter;
        }
    }
}

