/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import com.vaadin.flow.testcategory.ChromeTests;
import com.vaadin.flow.testutil.ViewOrUITest;
import com.vaadin.flow.testutil.net.PortProber;
import com.vaadin.testbench.TestBench;
import com.vaadin.testbench.parallel.Browser;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Before;
import org.junit.experimental.categories.Category;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ChromeTests.class})
public class ChromeBrowserTest
extends ViewOrUITest {
    private static InetAddress ipv4All;
    private static InetAddress ipv6All;

    @Before
    public void setup() throws Exception {
        if (Browser.CHROME == this.getRunLocallyBrowser() && !ChromeBrowserTest.isJavaInDebugMode()) {
            this.setDriver(ChromeBrowserTest.createHeadlessChromeDriver(this::updateHeadlessChromeOptions));
        } else {
            super.setup();
        }
    }

    protected void updateHeadlessChromeOptions(ChromeOptions chromeOptions) {
    }

    static boolean isJavaInDebugMode() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    }

    static WebDriver createHeadlessChromeDriver(Consumer<ChromeOptions> optionsUpdater) {
        for (int i = 0; i < 3; ++i) {
            try {
                return ChromeBrowserTest.tryCreateHeadlessChromeDriver(optionsUpdater);
            }
            catch (Exception e) {
                ChromeBrowserTest.getLogger().warn("Unable to create chromedriver on attempt " + i, (Throwable)e);
                continue;
            }
        }
        throw new RuntimeException("Gave up trying to create a chromedriver instance");
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ChromeBrowserTest.class);
    }

    private static WebDriver tryCreateHeadlessChromeDriver(Consumer<ChromeOptions> optionsUpdater) {
        ChromeOptions headlessOptions = ChromeBrowserTest.createHeadlessChromeOptions();
        optionsUpdater.accept(headlessOptions);
        int port = PortProber.findFreePort();
        ChromeDriverService service = (ChromeDriverService)((ChromeDriverService.Builder)new ChromeDriverService.Builder().usingPort(port)).withSilent(true).build();
        ChromeDriver chromeDriver = new ChromeDriver(service, headlessOptions);
        return TestBench.createDriver((WebDriver)chromeDriver);
    }

    @Override
    protected List<DesiredCapabilities> getHubBrowsersToTest() {
        return this.getBrowserCapabilities(Browser.CHROME);
    }

    @Override
    protected List<DesiredCapabilities> getBrowserCapabilities(Browser ... browsers) {
        return this.customizeCapabilities(super.getBrowserCapabilities(browsers));
    }

    protected List<DesiredCapabilities> customizeCapabilities(List<DesiredCapabilities> capabilities) {
        capabilities.stream().filter(cap -> "chrome".equalsIgnoreCase(cap.getBrowserName())).forEach(cap -> cap.setCapability("goog:chromeOptions", (Object)ChromeBrowserTest.createHeadlessChromeOptions()));
        return capabilities;
    }

    static ChromeOptions createHeadlessChromeOptions() {
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless", "--disable-gpu"});
        return options;
    }

    static {
        try {
            ipv4All = InetAddress.getByName("0.0.0.0");
            ipv6All = InetAddress.getByName("::0");
        }
        catch (UnknownHostException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

