/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.testutil;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.io.FileUtils;

public class FrontendStubs {
    public static final String WEBPACK_SERVER = "node_modules/webpack-dev-server/bin/webpack-dev-server.js";
    public static final String WEBPACK_TEST_OUT_FILE = "webpack-out.test";
    public static final String VITE_SERVER = "node_modules/vite/bin/vite.js";
    public static final String VITE_TEST_OUT_FILE = "vite-out.test";
    private static final String NPM_BIN_PATH = System.getProperty("os.name").startsWith("Windows") ? "node/node_modules/npm/bin/" : "node/lib/node_modules/npm/bin/";
    private static final String NPM_CACHE_PATH_STUB = "cache";

    private FrontendStubs() {
    }

    public static void createStubNode(ToolStubInfo stubNode, ToolStubInfo stubNpm, String baseDir) throws IOException {
        Objects.requireNonNull(stubNode);
        Objects.requireNonNull(stubNpm);
        if (stubNpm.isStubbed()) {
            File binDir = new File(baseDir, NPM_BIN_PATH);
            FileUtils.forceMkdir((File)binDir);
            String stub = stubNpm.getScript().replace("\\", "\\\\");
            FileUtils.writeStringToFile((File)new File(binDir, "npm-cli.js"), (String)stub, (Charset)StandardCharsets.UTF_8);
            FileUtils.writeStringToFile((File)new File(binDir, "npx-cli.js"), (String)stub, (Charset)StandardCharsets.UTF_8);
        }
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        if (stubNode.isStubbed()) {
            File nodeDir = new File(baseDir, "node");
            FileUtils.forceMkdir((File)nodeDir);
            File node = new File(baseDir, isWindows ? "node/node.exe" : "node/node");
            node.createNewFile();
            node.setExecutable(true);
            if (!isWindows) {
                FileUtils.write((File)node, (CharSequence)stubNode.getScript(), (String)"UTF-8");
            }
        }
    }

    public static void createStubNode(boolean stubNode, boolean stubNpm, String baseDir) throws IOException {
        File defaultNpmCacheDirStub = new File(new File(baseDir, NPM_BIN_PATH), NPM_CACHE_PATH_STUB);
        FileUtils.forceMkdir((File)defaultNpmCacheDirStub);
        ToolStubInfo nodeStubInfo = stubNode ? ToolStubInfo.builder(Tool.NODE).withCacheDir(defaultNpmCacheDirStub.getAbsolutePath()).build() : ToolStubInfo.none();
        ToolStubInfo npmStubInfo = stubNpm ? ToolStubInfo.builder(Tool.NPM).withCacheDir(defaultNpmCacheDirStub.getAbsolutePath()).build() : ToolStubInfo.none();
        FrontendStubs.createStubNode(nodeStubInfo, npmStubInfo, baseDir);
    }

    public static void createStubWebpackServer(String readyString, int milliSecondsToRun, String baseDir, boolean enableListening) throws IOException {
        FrontendStubs.createStubDevServer(new File(baseDir, WEBPACK_SERVER), WEBPACK_TEST_OUT_FILE, readyString, milliSecondsToRun, enableListening);
    }

    public static void createStubWebpackServer(String readyString, int milliSecondsToRun, String baseDir) throws IOException {
        FrontendStubs.createStubWebpackServer(readyString, milliSecondsToRun, baseDir, false);
    }

    public static void createStubViteServer(String readyString, int milliSecondsToRun, String baseDir, boolean enableListening) throws IOException {
        FrontendStubs.createStubDevServer(new File(baseDir, VITE_SERVER), VITE_TEST_OUT_FILE, readyString, milliSecondsToRun, enableListening);
    }

    public static void createStubViteServer(String readyString, int milliSecondsToRun, String baseDir) throws IOException {
        FrontendStubs.createStubViteServer(readyString, milliSecondsToRun, baseDir, false);
    }

    private static void createStubDevServer(File serverFile, String serverOutputFile, String readyString, int milliSecondsToRun, boolean enableListening) throws IOException {
        FileUtils.forceMkdirParent((File)serverFile);
        serverFile.createNewFile();
        serverFile.setExecutable(true);
        StringBuilder sb = new StringBuilder();
        sb.append("#!/user/bin/env node\n");
        sb.append("const args = String(process.argv);\n");
        sb.append("const fs = require('fs');\n");
        sb.append("const http = require('http');\n");
        sb.append("fs.writeFileSync('").append(serverOutputFile).append("', args);\n");
        if (enableListening) {
            sb.append("const port = Number.parseInt(process.argv[").append("process.argv.indexOf('--port') + 1").append("]);\n");
            sb.append("const server = new http.Server((req, res) => {\n");
            sb.append("  res.writeHead(200, {").append("'Content-Type': 'application/json',").append("});\n");
            sb.append("  res.write('{}');\n");
            sb.append("  res.end();\n");
            sb.append("});\n");
            sb.append("server.listen(port);\n");
            sb.append("setTimeout(() => server.close(), ").append(milliSecondsToRun).append(");\n");
        } else {
            sb.append("setTimeout(() => {}, ").append(milliSecondsToRun).append(");\n");
        }
        sb.append("console.log(args);\n");
        sb.append("console.log('[wps]: ").append(readyString).append(".');\n");
        FileUtils.write((File)serverFile, (CharSequence)sb.toString(), (String)"UTF-8");
    }

    public static enum Tool {
        NODE,
        NPM;

    }

    public static class ToolStubBuilder {
        private static final String DEFAULT_NPM_VERSION = "10.9.2";
        private static final String DEFAULT_NODE_VERSION = "22.14.0";
        private String version;
        private String cacheDir;
        private final Tool tool;

        private ToolStubBuilder(Tool tool) {
            this.tool = tool;
        }

        public ToolStubBuilder withVersion(String version) {
            this.version = version;
            return this;
        }

        public ToolStubBuilder withCacheDir(String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public ToolStubInfo build() {
            String script;
            StringBuilder scriptBuilder = new StringBuilder();
            switch (this.tool) {
                case NPM: {
                    script = this.generateNpmScript(scriptBuilder);
                    break;
                }
                case NODE: {
                    script = this.generateNodeScript(scriptBuilder);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown build tool");
                }
            }
            return new ToolStubInfo(true, script);
        }

        private String generateNodeScript(StringBuilder scriptBuilder) {
            this.version = this.version == null ? DEFAULT_NODE_VERSION : this.version;
            scriptBuilder.append("  if [ \"$arg\" = \"--version\" ] || [ \"$arg\" = \"-v\" ]; then\n").append("    echo ").append(this.version).append("\n").append("    break\n").append("  fi\n");
            if (this.cacheDir != null) {
                scriptBuilder.append("  if [ \"$arg\" = \"cache\" ]; then\n").append("    echo ").append(this.cacheDir).append("\n").append("    break\n").append("  fi\n");
            }
            String script = String.format("#!/bin/sh%nfor arg in \"$@\"%ndo%n%sdone%nsleep 1", scriptBuilder.toString());
            return script;
        }

        private String generateNpmScript(StringBuilder scriptBuilder) {
            this.version = this.version == null ? DEFAULT_NPM_VERSION : this.version;
            scriptBuilder.append("process.argv.includes('--version') && console.log('").append(this.version).append("');\n");
            if (this.cacheDir != null) {
                scriptBuilder.append("process.argv.includes('cache') && console.log('").append(this.cacheDir).append("');\n");
            }
            String script = scriptBuilder.toString();
            return script;
        }
    }

    public static final class ToolStubInfo {
        private final boolean stubbed;
        private final String script;

        private ToolStubInfo(boolean stubbed, String script) {
            this.stubbed = stubbed;
            assert (!stubbed || script != null && !script.isEmpty()) : "Script may not be empty for stubbed tool";
            this.script = script;
        }

        public static ToolStubBuilder builder(Tool tool) {
            Objects.requireNonNull(tool, "Build tool may not be empty");
            return new ToolStubBuilder(tool);
        }

        public static ToolStubInfo none() {
            return new ToolStubInfo(false, "");
        }

        public boolean isStubbed() {
            return this.stubbed;
        }

        public String getScript() {
            return this.script;
        }
    }
}

