/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.DevBundleUtils;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.FallibleCommand;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskCopyNpmAssetsFiles;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.node.ObjectNode;

public class TaskRunDevBundleBuild
implements FallibleCommand {
    public static final String README = "This directory is automatically generated by Vaadin and contains the pre-compiled \nfrontend files/resources for your project (frontend development bundle).\n\nIt should be added to Version Control System and committed, so that other developers\ndo not have to compile it again.\n\nFrontend development bundle is automatically updated when needed:\n- an npm/pnpm package is added with @NpmPackage or directly into package.json\n- CSS, JavaScript or TypeScript files are added with @CssImport, @JsModule or @JavaScript\n- Vaadin add-on with front-end customizations is added\n- Custom theme imports/assets added into 'theme.json' file\n- Exported web component is added.\n\nIf your project development needs a hot deployment of the frontend changes, \nyou can switch Flow to use Vite development server:\n- set `vaadin.frontend.hotdeploy=true` in `application.properties`\n- configure `vaadin-maven-plugin`:\n```\n   <configuration>\n       <frontendHotdeploy>true</frontendHotdeploy>\n   </configuration>\n```\n- configure `jetty-maven-plugin`:\n```\n   <configuration>\n       <systemProperties>\n           <vaadin.frontend.hotdeploy>true</vaadin.frontend.hotdeploy>\n       </systemProperties>\n   </configuration>\n```\n\nRead more [about Vaadin development mode](https://vaadin.com/docs/latest/flow/configuration/development-mode#precompiled-bundle).";
    public static final String VAADIN_JSON = "vaadin.json";
    private final Options options;

    TaskRunDevBundleBuild(Options options) {
        this.options = options;
        TaskRunDevBundleBuild.getLogger().info("Creating a new development mode bundle. This can take a while but will only run when the project setup is changed, addons are added or frontend files are modified");
    }

    @Override
    public void execute() throws ExecutionFailedException {
        this.runFrontendBuildTool("Vite", "vite", "vite", "build");
        this.copyPackageLockToBundleFolder();
        this.addVaadinVersionToDevBundle();
        this.addReadme();
        new TaskCopyNpmAssetsFiles(this.options).execute();
        if (this.options.isCompressBundle()) {
            DevBundleUtils.compressBundle(this.options.getNpmFolder(), this.getDevBundleFolderInTarget());
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(TaskRunDevBundleBuild.class);
    }

    private File getDevBundleFolderInTarget() {
        return new File(new File(this.options.getNpmFolder(), this.options.getBuildDirectoryName()), "dev-bundle");
    }

    private File getDevBundleFolderInSrc() {
        return new File(this.options.getNpmFolder(), "src/main/bundles/");
    }

    private void runFrontendBuildTool(String toolName, String packageName, String binaryName, String ... params) throws ExecutionFailedException {
        File buildExecutable;
        Logger logger = TaskRunDevBundleBuild.getLogger();
        FrontendToolsSettings settings = new FrontendToolsSettings(this.options.getNpmFolder().getAbsolutePath(), () -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        settings.setNodeDownloadRoot(this.options.getNodeDownloadRoot());
        settings.setForceAlternativeNode(this.options.isRequireHomeNodeExec());
        settings.setUseGlobalPnpm(this.options.isUseGlobalPnpm());
        settings.setNodeVersion(this.options.getNodeVersion());
        settings.setIgnoreVersionChecks(this.options.isFrontendIgnoreVersionChecks());
        FrontendTools frontendTools = new FrontendTools(settings);
        try {
            buildExecutable = frontendTools.getNpmPackageExecutable(packageName, binaryName, this.options.getNpmFolder()).toFile();
        }
        catch (FrontendUtils.CommandExecutionException e) {
            throw new IllegalStateException(String.format("Unable to locate %s executable. Expected the \"%s\" npm package to be installed and to provide the \"%s\" binary. Double check that the npm dependencies are installed.", toolName, packageName, binaryName));
        }
        if (!buildExecutable.isFile()) {
            throw new IllegalStateException(String.format("Unable to locate %s executable by path '%s'. Double check that the plugin is executed correctly", toolName, buildExecutable.getAbsolutePath()));
        }
        String nodePath = frontendTools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(nodePath);
        command.add(buildExecutable.getAbsolutePath());
        command.addAll(Arrays.asList(params));
        String commandString = command.stream().collect(Collectors.joining(" "));
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        builder.environment().put("devBundle", "true");
        builder.environment().put("NODE_ENV", "development");
        Process process = null;
        try {
            builder.directory(this.options.getNpmFolder());
            builder.redirectInput(ProcessBuilder.Redirect.PIPE);
            builder.redirectErrorStream(true);
            process = builder.start();
            Runtime.getRuntime().addShutdownHook(new Thread(process::destroyForcibly));
            logger.debug("Output of `{}`:", (Object)commandString);
            StringBuilder toolOutput = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));){
                String stdoutLine;
                while ((stdoutLine = reader.readLine()) != null) {
                    logger.debug(stdoutLine);
                    toolOutput.append(stdoutLine).append(System.lineSeparator());
                }
            }
            int errorCode = process.waitFor();
            if (errorCode != 0) {
                logger.error("Command `{}` failed:\n{}", (Object)commandString, (Object)toolOutput);
                throw new ExecutionFailedException(SharedUtil.capitalize(toolName) + " build exited with a non zero status");
            }
            logger.info("Development frontend bundle built");
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error when running `{}`", (Object)commandString, (Object)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new ExecutionFailedException("Command '" + commandString + "' failed to finish", e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
        }
    }

    private void copyPackageLockToBundleFolder() {
        File devBundleFolder = this.getDevBundleFolderInTarget();
        assert (devBundleFolder.exists()) : "No dev-bundle folder created";
        String packageLockFile = this.options.isEnablePnpm() ? "pnpm-lock.yaml" : "package-lock.json";
        File packageLockJson = new File(this.options.getNpmFolder(), packageLockFile);
        if (packageLockJson.exists()) {
            try {
                Files.copy(packageLockJson.toPath(), new File(devBundleFolder, packageLockFile).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                TaskRunDevBundleBuild.getLogger().error("Failed to copy '" + packageLockFile + "' to " + String.valueOf(this.getDevBundleFolderInTarget()), (Throwable)e);
            }
        }
    }

    private void addVaadinVersionToDevBundle() {
        File devBundleFolder = this.getDevBundleFolderInTarget();
        assert (devBundleFolder.exists()) : "No dev-bundle folder created";
        Optional<String> vaadinVersion = FrontendUtils.getVaadinVersion(this.options.getClassFinder());
        if (vaadinVersion.isPresent()) {
            ObjectNode vaadinObject = JacksonUtils.createObjectNode();
            vaadinObject.put("version", vaadinVersion.get());
            try {
                Files.writeString(new File(devBundleFolder, VAADIN_JSON).toPath(), (CharSequence)vaadinObject.toPrettyString(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                TaskRunDevBundleBuild.getLogger().error("Failed to write vaadin version to '" + String.valueOf(new File(devBundleFolder, VAADIN_JSON)) + "'", (Throwable)e);
            }
        }
    }

    private void addReadme() {
        File readme;
        if (!this.options.isCompressBundle()) {
            return;
        }
        File devBundleFolder = this.getDevBundleFolderInSrc();
        if (!devBundleFolder.exists()) {
            devBundleFolder.mkdirs();
        }
        if ((readme = new File(devBundleFolder, "README.md")).exists()) {
            return;
        }
        try {
            boolean created = readme.createNewFile();
            if (created) {
                Files.writeString(readme.toPath(), (CharSequence)README, new OpenOption[0]);
            } else {
                TaskRunDevBundleBuild.getLogger().warn("Failed to create " + String.valueOf(readme));
            }
        }
        catch (Exception e) {
            TaskRunDevBundleBuild.getLogger().error("Failed to create " + String.valueOf(readme), (Throwable)e);
        }
    }
}

