/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.shared.BrowserDetails;
import java.io.Serializable;
import java.util.Locale;
import org.slf4j.LoggerFactory;

public class WebBrowser
implements Serializable {
    private String userAgent = null;
    private Locale locale = null;
    private String address = null;
    private boolean secureConnection = false;
    private BrowserDetails browserDetails = null;

    WebBrowser() {
    }

    WebBrowser(VaadinRequest request) {
        this.locale = request.getLocale();
        this.address = request.getRemoteAddr();
        this.secureConnection = request.isSecure();
        this.userAgent = request.getHeader("User-Agent");
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    private BrowserDetails getBrowserDetails() {
        if (this.userAgent != null && this.browserDetails == null) {
            this.browserDetails = new BrowserDetails(this.userAgent){

                @Override
                protected void log(String error, Exception e) {
                    LoggerFactory.getLogger(BrowserDetails.class).debug(error);
                }
            };
        }
        return this.browserDetails;
    }

    @Deprecated(since="25.0")
    public String getBrowserApplication() {
        return this.userAgent;
    }

    public String getAddress() {
        return this.address;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    @Deprecated(since="25.0")
    public boolean isFirefox() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isFirefox();
    }

    @Deprecated(since="25.0")
    public boolean isIE() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isIE();
    }

    @Deprecated(since="25.0")
    public boolean isEdge() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isEdge();
    }

    @Deprecated(since="25.0")
    public boolean isSafari() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isSafari();
    }

    @Deprecated(since="25.0")
    public boolean isOpera() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isOpera();
    }

    @Deprecated(since="25.0")
    public boolean isChrome() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isChrome();
    }

    @Deprecated(since="25.0")
    public int getBrowserMajorVersion() {
        if (this.getBrowserDetails() == null) {
            return -1;
        }
        return this.browserDetails.getBrowserMajorVersion();
    }

    @Deprecated(since="25.0")
    public int getBrowserMinorVersion() {
        if (this.getBrowserDetails() == null) {
            return -1;
        }
        return this.browserDetails.getBrowserMinorVersion();
    }

    @Deprecated(since="25.0")
    public boolean isLinux() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isLinux();
    }

    @Deprecated(since="25.0")
    public boolean isMacOSX() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isMacOSX();
    }

    @Deprecated(since="25.0")
    public boolean isWindows() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isWindows();
    }

    @Deprecated(since="25.0")
    public boolean isWindowsPhone() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isWindowsPhone();
    }

    @Deprecated(since="25.0")
    public boolean isAndroid() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isAndroid();
    }

    public boolean isIPhone() {
        return this.userAgent != null && (this.userAgent.contains("macintosh") || this.userAgent.contains("mac osx") || this.userAgent.contains("mac os x")) && this.userAgent.contains("iphone");
    }

    @Deprecated(since="25.0")
    public boolean isChromeOS() {
        if (this.getBrowserDetails() == null) {
            return false;
        }
        return this.browserDetails.isChromeOS();
    }
}

