/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.di;

import com.vaadin.flow.component.page.AppShellConfigurator;
import com.vaadin.flow.di.AbstractLookupInitializer;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.OneTimeInitializerPredicate;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.function.VaadinApplicationInitializationBootstrap;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.DefaultRoutePathProvider;
import com.vaadin.flow.router.RoutePathProvider;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.StaticFileHandlerFactory;
import com.vaadin.flow.server.StaticFileServer;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.AppShellPredicate;
import com.vaadin.flow.server.startup.ApplicationConfigurationFactory;
import com.vaadin.flow.server.startup.DefaultApplicationConfigurationFactory;
import jakarta.servlet.ServletException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class LookupInitializer
implements AbstractLookupInitializer {
    protected static final String SPI = " SPI: ";
    protected static final String ONE_IMPL_REQUIRED = ". Only one implementation should be registered. Use lookupAll to get all instances of the given type.";
    protected static final String SEVERAL_IMPLS = "Found several implementations in the classpath for ";

    @Override
    public void initialize(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services, VaadinApplicationInitializationBootstrap bootstrap) throws ServletException {
        services.put(OneTimeInitializerPredicate.class, Collections.singleton(RegularOneTimeInitializerPredicate.class));
        this.ensureService(services, ResourceProvider.class, ResourceProviderImpl.class);
        this.ensureService(services, AppShellPredicate.class, AppShellPredicateImpl.class);
        this.ensureService(services, ApplicationConfigurationFactory.class, DefaultApplicationConfigurationFactory.class);
        this.ensureService(services, StaticFileHandlerFactory.class, StaticFileHandlerFactoryImpl.class);
        this.ensureService(services, RoutePathProvider.class, DefaultRoutePathProvider.class);
        bootstrap.bootstrap(this.createLookup(context, services));
    }

    protected Lookup createLookup(VaadinContext context, Map<Class<?>, Collection<Class<?>>> services) {
        return new LookupImpl(services, this::instantiate);
    }

    protected <T> void ensureService(Map<Class<?>, Collection<Class<?>>> services, Class<T> serviceType, Class<? extends T> serviceImpl) {
        Collection impls = services.get(serviceType);
        if (impls == null) {
            impls = Collections.emptyList();
        }
        if ((impls = (Collection)impls.stream().filter(clazz -> !clazz.equals(serviceImpl)).collect(Collectors.toList())).isEmpty()) {
            services.put(serviceType, Collections.singletonList(serviceImpl));
        } else {
            if (impls.size() > 1) {
                throw new IllegalStateException(SEVERAL_IMPLS + serviceType.getSimpleName() + SPI + String.valueOf(impls) + ONE_IMPL_REQUIRED);
            }
            services.put(serviceType, impls);
        }
    }

    protected <T> T instantiate(Class<T> serviceClass, Class<?> implementation) {
        if (RegularOneTimeInitializerPredicate.class.equals(implementation)) {
            return serviceClass.cast(new RegularOneTimeInitializerPredicate());
        }
        if (StaticFileHandlerFactoryImpl.class.equals(implementation)) {
            return serviceClass.cast(new StaticFileHandlerFactoryImpl());
        }
        return serviceClass.cast(ReflectTools.createInstance(implementation));
    }

    public static Set<Class<?>> getDefaultImplementations() {
        return Set.of(RegularOneTimeInitializerPredicate.class, StaticFileHandlerFactoryImpl.class, LookupImpl.class, ResourceProviderImpl.class, AppShellPredicateImpl.class, DefaultRoutePathProvider.class, DefaultApplicationConfigurationFactory.class);
    }

    private static class RegularOneTimeInitializerPredicate
    implements OneTimeInitializerPredicate {
        private RegularOneTimeInitializerPredicate() {
        }

        @Override
        public boolean runOnce() {
            return true;
        }
    }

    protected static class ResourceProviderImpl
    implements ResourceProvider {
        private Map<String, CachedStreamData> cache = new ConcurrentHashMap<String, CachedStreamData>();

        @Override
        public URL getApplicationResource(String path) {
            return ResourceProviderImpl.class.getClassLoader().getResource(path);
        }

        @Override
        public List<URL> getApplicationResources(String path) throws IOException {
            return Collections.list(ResourceProviderImpl.class.getClassLoader().getResources(path));
        }

        @Override
        public URL getClientResource(String path) {
            return this.getApplicationResource(path);
        }

        @Override
        public InputStream getClientResourceAsStream(String path) throws IOException {
            CachedStreamData cached = this.cache.computeIfAbsent(path, key -> {
                CachedStreamData cachedStreamData;
                block8: {
                    URL url = this.getClientResource((String)key);
                    InputStream stream = url.openStream();
                    try {
                        ByteArrayOutputStream tempBuffer = new ByteArrayOutputStream();
                        stream.transferTo(tempBuffer);
                        cachedStreamData = new CachedStreamData(tempBuffer.toByteArray(), null);
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            return new CachedStreamData(null, e);
                        }
                    }
                    stream.close();
                }
                return cachedStreamData;
            });
            IOException exception = cached.exception;
            if (exception == null) {
                return new ByteArrayInputStream(cached.data);
            }
            throw exception;
        }
    }

    protected static class AppShellPredicateImpl
    implements AppShellPredicate {
        @Override
        public boolean isShell(Class<?> clz) {
            return AppShellConfigurator.class.isAssignableFrom(clz);
        }
    }

    private static class StaticFileHandlerFactoryImpl
    implements StaticFileHandlerFactory {
        private StaticFileHandlerFactoryImpl() {
        }

        @Override
        public StaticFileHandler createHandler(VaadinService service) {
            return new StaticFileServer(service);
        }
    }

    protected static class LookupImpl
    implements Lookup {
        protected final Map<Class<?>, Collection<Object>> serviceMap = new HashMap();

        protected LookupImpl(Map<Class<?>, Collection<Class<?>>> initialServices, BiFunction<Class<?>, Class<?>, Object> factory) {
            initialServices.forEach((serviceClass, impls) -> this.serviceMap.put((Class<?>)serviceClass, impls.stream().map(impl -> factory.apply((Class<?>)serviceClass, (Class<?>)impl)).filter(Objects::nonNull).collect(Collectors.toList())));
        }

        @Override
        public <T> T lookup(Class<T> serviceClass) {
            Collection<Object> registered = this.serviceMap.get(serviceClass);
            if (registered == null || registered.isEmpty()) {
                ServiceLoader<T> loader = ServiceLoader.load(serviceClass);
                ArrayList<T> services = new ArrayList<T>();
                Iterator<T> iterator = loader.iterator();
                while (iterator.hasNext()) {
                    services.add(iterator.next());
                }
                if (services.size() > 1) {
                    throw new IllegalStateException(LookupInitializer.SEVERAL_IMPLS + String.valueOf(serviceClass) + LookupInitializer.SPI + String.valueOf(services) + LookupInitializer.ONE_IMPL_REQUIRED);
                }
                if (services.size() == 1) {
                    return (T)services.get(0);
                }
                return null;
            }
            if (registered.size() > 1) {
                throw new IllegalStateException(LookupInitializer.SEVERAL_IMPLS + String.valueOf(serviceClass) + LookupInitializer.SPI + String.valueOf(registered) + LookupInitializer.ONE_IMPL_REQUIRED);
            }
            return serviceClass.cast(registered.iterator().next());
        }

        @Override
        public <T> Collection<T> lookupAll(Class<T> serviceClass) {
            Set registeredClasses;
            ArrayList result = new ArrayList();
            Collection<Object> registered = this.serviceMap.get(serviceClass);
            Set set = registeredClasses = registered == null ? Collections.emptySet() : registered.stream().map(Object::getClass).collect(Collectors.toSet());
            if (registered != null) {
                registered.forEach(service -> result.add(serviceClass.cast(service)));
            }
            ServiceLoader<T> loader = ServiceLoader.load(serviceClass);
            for (T next : loader) {
                if (registeredClasses.contains(next.getClass())) continue;
                result.add(next);
            }
            return result;
        }
    }

    private static class CachedStreamData {
        private final byte[] data;
        private final IOException exception;

        private CachedStreamData(byte[] data, IOException exception) {
            this.data = data;
            this.exception = exception;
        }
    }
}

