/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.frontend.AbstractFileGeneratorFallibleCommand;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUpdateThemeImport
extends AbstractFileGeneratorFallibleCommand {
    public static final String APPLICATION_META_INF_RESOURCES = "src/main/resources/META-INF/resources";
    public static final String APPLICATION_STATIC_RESOURCES = "src/main/resources/static";
    private static final String EXPORT_MODULES_DEF = "export declare const applyTheme: (target: Node) => void;";
    private final File themeImportFile;
    private final File themeImportFileDefinition;
    private final String generatedFolder;
    private final ThemeDefinition theme;
    private final Options options;

    TaskUpdateThemeImport(ThemeDefinition theme, Options options) {
        this.theme = theme;
        this.options = options;
        File frontendGeneratedFolder = new File(options.getFrontendDirectory(), "generated/");
        this.generatedFolder = options.getNpmFolder().toPath().relativize(frontendGeneratedFolder.toPath()).toString().replaceAll("\\\\", "/");
        this.themeImportFile = new File(frontendGeneratedFolder, "theme.js");
        this.themeImportFileDefinition = new File(frontendGeneratedFolder, "theme.d.ts");
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.theme == null || this.theme.getName().isEmpty()) {
            if (this.themeImportFile.exists()) {
                this.themeImportFile.delete();
                this.themeImportFileDefinition.delete();
            }
            try {
                this.writeIfChanged(new File(this.options.getFrontendGeneratedFolder(), "css.generated.d.ts"), "export declare const applyCss: (target: Node) => void;");
            }
            catch (IOException e) {
                throw new ExecutionFailedException("Unable to write theme import file", e);
            }
            return;
        }
        this.verifyThemeDirectoryExistence();
        if (!this.themeImportFile.getParentFile().mkdirs()) {
            LoggerFactory.getLogger(this.getClass()).debug("Didn't create folders as they probably already exist. If there is a problem check access rights for folder {}", (Object)this.themeImportFile.getParentFile().getAbsolutePath());
        }
        try {
            this.writeIfChanged(this.themeImportFile, String.format("import {applyTheme as _applyTheme} from './theme-%s.generated.js';%nexport const applyTheme = _applyTheme;%n", this.theme.getName()));
            this.writeIfChanged(this.themeImportFileDefinition, EXPORT_MODULES_DEF);
        }
        catch (IOException e) {
            throw new ExecutionFailedException("Unable to write theme import file", e);
        }
    }

    private void verifyThemeDirectoryExistence() throws ExecutionFailedException {
        File themeComponents;
        String themeName = this.theme.getName();
        String themePath = String.join((CharSequence)"/", "themes", themeName);
        List<String> appThemePossiblePaths = this.getAppThemePossiblePaths(themePath);
        List existingAppThemeDirectories = appThemePossiblePaths.stream().map(path -> new File(this.options.getNpmFolder(), (String)path)).filter(File::exists).collect(Collectors.toList());
        if (existingAppThemeDirectories.isEmpty()) {
            String errorMessage = "Discovered @Theme annotation with theme name '%s', but could not find the theme directory in the project or available as a jar dependency. Check if you forgot to create the folder under '%s' or have mistyped the theme or folder name for '%s'.";
            throw new ExecutionFailedException(String.format(errorMessage, themeName, new File(this.options.getFrontendDirectory(), "themes").getPath(), themeName));
        }
        if (existingAppThemeDirectories.size() >= 2) {
            boolean themeFoundInJar = existingAppThemeDirectories.stream().map(File::getPath).anyMatch(path -> path.contains(Paths.get(this.generatedFolder, "jar-resources").toString()));
            if (themeFoundInJar) {
                String errorMessage = "Theme '%s' should not exist inside a jar and in the project at the same time.%nExtending another theme is possible by adding { \"parent\": \"your-parent-theme\" } entry to the 'theme.json' file inside your theme folder.";
                throw new ExecutionFailedException(String.format(errorMessage, themeName));
            }
            String errorMessage = "Discovered Theme folder for theme '%s' in more than one place in the project. Please make sure there is only one theme folder with name '%s' exists in the your project. The recommended place to put the theme folder inside the project is '%s'";
            throw new ExecutionFailedException(String.format(errorMessage, themeName, themeName, new File(this.options.getFrontendDirectory(), "themes").getPath()));
        }
        if (!this.options.getFeatureFlags().isEnabled(FeatureFlags.COMPONENT_STYLE_INJECTION) && (themeComponents = new File((File)existingAppThemeDirectories.get(0), "components")).exists() && themeComponents.isDirectory() && themeComponents.listFiles().length > 0) {
            String styleFiles = Arrays.stream(themeComponents.listFiles()).map(File::getName).filter(file -> file.endsWith(".css") || file.endsWith(".sass")).collect(Collectors.joining("\n"));
            this.getLogger().warn("Theme '{}' contains component styles, but the '{}' feature flag is not set, so component styles will not be applied for\n{}", new Object[]{themeName, FeatureFlags.COMPONENT_STYLE_INJECTION.getId(), styleFiles});
        }
    }

    private List<String> getAppThemePossiblePaths(String themePath) {
        String frontendTheme = String.join((CharSequence)"/", this.options.getNpmFolder().toPath().relativize(this.options.getFrontendDirectory().toPath()).toString(), themePath).replaceAll("\\\\", "/");
        String themePathInMetaInfResources = String.join((CharSequence)"/", APPLICATION_META_INF_RESOURCES, themePath);
        String themePathInStaticResources = String.join((CharSequence)"/", APPLICATION_STATIC_RESOURCES, themePath);
        String themePathInClassPathResources = String.join((CharSequence)"", this.generatedFolder + "/jar-resources", "/", themePath);
        return Arrays.asList(frontendTheme, themePathInMetaInfResources, themePathInStaticResources, themePathInClassPathResources);
    }

    Logger getLogger() {
        return LoggerFactory.getLogger(TaskUpdateThemeImport.class);
    }
}

