/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.TaskInstallFrontendBuildPlugins;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.JsonNode;

class FrontendPluginsUtil {
    protected static final String PLUGIN_TARGET = "plugins";

    private FrontendPluginsUtil() {
    }

    protected static List<String> getPlugins() {
        try {
            JsonNode jsonFile = FrontendPluginsUtil.getJsonFile("plugins/plugins.json");
            if (jsonFile == null) {
                throw new IllegalStateException("Couldn't locate plugins/plugins.json");
            }
            JsonNode plugins = jsonFile.get(PLUGIN_TARGET);
            ArrayList<String> pluginsToInstall = new ArrayList<String>(plugins.size());
            for (int i = 0; i < plugins.size(); ++i) {
                pluginsToInstall.add(plugins.get(i).textValue());
            }
            return pluginsToInstall;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException("Couldn't load plugins/plugins.json", ioe);
        }
    }

    protected static JsonNode getJsonFile(String jsonFilePath) throws IOException {
        String jsonString;
        block9: {
            URL urlResource = FrontendPluginsUtil.getResourceUrl(jsonFilePath);
            if (urlResource == null) {
                return null;
            }
            File jsonFile = new File(urlResource.getFile());
            if (!jsonFile.exists()) {
                try (InputStream resourceAsStream = FrontendPluginsUtil.getResourceAsStream(jsonFilePath);){
                    if (resourceAsStream != null) {
                        jsonString = FrontendUtils.streamToString(resourceAsStream);
                        break block9;
                    }
                    JsonNode jsonNode = null;
                    return jsonNode;
                }
            }
            jsonString = Files.readString(jsonFile.toPath());
        }
        return JacksonUtils.readTree(jsonString);
    }

    protected static URL getResourceUrl(String resource) {
        ClassLoader cl = TaskInstallFrontendBuildPlugins.class.getClassLoader();
        return cl.getResource(resource);
    }

    protected static InputStream getResourceAsStream(String resource) {
        ClassLoader cl = TaskInstallFrontendBuildPlugins.class.getClassLoader();
        return cl.getResourceAsStream(resource);
    }
}

