/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.ClassList;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementEffect;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeList;
import com.vaadin.flow.internal.nodefeature.SerializableNodeList;
import com.vaadin.flow.shared.Registration;
import com.vaadin.signals.BindingActiveException;
import com.vaadin.signals.Signal;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ElementClassList
extends SerializableNodeList<String> {
    private Map<String, SignalBinding> bindingsByName;

    public ElementClassList(StateNode node) {
        super(node);
    }

    public ClassList getClassList() {
        return new ClassListView(this);
    }

    private Map<String, SignalBinding> getBindings() {
        if (this.bindingsByName == null) {
            this.bindingsByName = new HashMap<String, SignalBinding>();
        }
        return this.bindingsByName;
    }

    private boolean isBound(String name) {
        return this.bindingsByName != null && this.bindingsByName.containsKey(name);
    }

    private void clearBindings() {
        if (this.bindingsByName == null || this.bindingsByName.isEmpty()) {
            return;
        }
        for (SignalBinding binding : this.bindingsByName.values()) {
            if (binding.registration == null) continue;
            binding.registration.remove();
        }
        this.bindingsByName.clear();
    }

    private static class ClassListView
    extends NodeList.SetView<String>
    implements ClassList {
        private final ElementClassList elementClassList;

        private ClassListView(ElementClassList elementClassList) {
            super(elementClassList);
            this.elementClassList = elementClassList;
        }

        @Override
        protected void validate(String className) {
            if (className == null) {
                throw new IllegalArgumentException("Class name cannot be null");
            }
            if (className.isEmpty()) {
                throw new IllegalArgumentException("Class name cannot be empty");
            }
            if (className.indexOf(32) != -1) {
                throw new IllegalArgumentException("Class name cannot contain spaces");
            }
        }

        private void internalSetPresence(String name, boolean set) {
            ElementClassList list = this.elementClassList;
            int index = list.indexOf(name);
            if (set) {
                if (index == -1) {
                    list.add(list.size(), name);
                }
            } else if (index != -1) {
                list.remove(index);
            }
        }

        private Map<String, SignalBinding> getBindings() {
            return this.elementClassList.getBindings();
        }

        private boolean isBound(String name) {
            return this.elementClassList.isBound(name);
        }

        private StateNode getNode() {
            return this.elementClassList.getNode();
        }

        @Override
        public void bind(String name, Signal<Boolean> signal) {
            this.validate(name);
            if (signal == null) {
                SignalBinding old;
                if (this.isBound(name) && (old = this.getBindings().remove(name)) != null && old.registration != null) {
                    old.registration.remove();
                }
                return;
            }
            if (this.isBound(name)) {
                throw new BindingActiveException("Class name '" + name + "' is already bound to a signal");
            }
            Element owner = Element.get(this.getNode());
            Registration registration = ElementEffect.bind(owner, signal, (element, value) -> this.internalSetPresence(name, Boolean.TRUE.equals(value)));
            SignalBinding binding = new SignalBinding(signal, registration, name);
            this.getBindings().put(name, binding);
        }

        @Override
        public boolean add(String className) {
            if (this.isBound(className)) {
                throw new BindingActiveException("Class name '" + className + "' is bound and cannot be modified manually");
            }
            return super.add(className);
        }

        @Override
        public boolean remove(Object className) {
            String name;
            if (className instanceof String && this.isBound(name = (String)className)) {
                throw new BindingActiveException("Class name '" + name + "' is bound and cannot be modified manually");
            }
            return super.remove(className);
        }

        @Override
        public void clear() {
            this.clearBindings();
            super.clear();
        }

        public void clearBindings() {
            this.elementClassList.clearBindings();
        }
    }

    private record SignalBinding(Signal<Boolean> signal, Registration registration, String name) implements Serializable
    {
    }
}

