/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.hotswap;

import com.vaadin.flow.hotswap.HotswapEvent;
import com.vaadin.flow.server.VaadinService;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class HotswapResourceEvent
extends HotswapEvent {
    private final Set<URI> changedResources;

    public HotswapResourceEvent(VaadinService vaadinService, Set<URI> changedResources) {
        super(vaadinService);
        this.changedResources = Set.copyOf((Collection)Objects.requireNonNull(changedResources, "Changed resources cannot be null"));
    }

    public Set<URI> getChangedResources() {
        return this.changedResources;
    }

    public boolean anyMatches(String regexp) {
        Predicate<String> predicate = Pattern.compile(regexp).asMatchPredicate();
        return this.changedResources.stream().map(URI::toString).anyMatch(predicate);
    }
}

