/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.FileIOUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.server.Version;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.ExecutionFailedException;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;

public class TaskGenerateIndexTs
extends AbstractTaskClientGenerator {
    private static final String ROUTES_JS_IMPORT_PATH_TOKEN = "%routesJsImportPath%";
    private final File frontendDirectory;
    private Options options;

    TaskGenerateIndexTs(Options options) {
        this.frontendDirectory = options.getFrontendDirectory();
        this.options = options;
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (!this.shouldGenerate()) {
            this.cleanup();
            return;
        }
        File generatedFile = this.getGeneratedFile();
        try {
            this.writeIfChanged(generatedFile, this.getFileContent());
        }
        catch (IOException exception) {
            String errorMessage = String.format("Error writing '%s'", generatedFile);
            throw new ExecutionFailedException(errorMessage, exception);
        }
    }

    @Override
    protected File getGeneratedFile() {
        if (this.options.isReactEnabled()) {
            return new File(new File(this.frontendDirectory, "generated/"), "index.tsx");
        }
        return new File(new File(this.frontendDirectory, "generated/"), "index.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return Arrays.asList("index.tsx", "index.ts", "index.js").stream().map(type -> new File(this.frontendDirectory, (String)type)).filter(File::exists).peek(this::compareActualIndexWithIndexTemplate).findAny().isEmpty();
    }

    @Override
    protected String getFileContent() throws IOException {
        String indexTemplate;
        String indexFile = "index.ts";
        if (this.options.isReactEnabled()) {
            indexFile = "index-react.tsx";
        }
        try (InputStream indexTsStream = this.getClass().getResourceAsStream(indexFile);){
            indexTemplate = StringUtil.toUTF8String(indexTsStream);
            if (this.options.isReactEnabled()) {
                File routesTsx = new File(this.frontendDirectory, "routes.tsx");
                indexTemplate = indexTemplate.replace(ROUTES_JS_IMPORT_PATH_TOKEN, routesTsx.exists() ? "Frontend/routes.js" : "Frontend/generated/routes.js");
            }
        }
        return indexTemplate;
    }

    private void cleanup() {
        FileIOUtils.deleteFileQuietly(this.getGeneratedFile());
    }

    static String ensureValidRelativePath(String relativePath) {
        if (!((String)relativePath).startsWith(".")) {
            relativePath = "./" + (String)relativePath;
        }
        return relativePath;
    }

    private void compareActualIndexWithIndexTemplate(File indexFileExist) {
        String indexContent = null;
        String indexTemplate = null;
        try {
            indexContent = Files.readString(indexFileExist.toPath());
            indexTemplate = this.getFileContent();
        }
        catch (IOException e) {
            TaskGenerateIndexTs.log().warn("Failed to read file content", (Throwable)e);
        }
        if (indexContent != null && !indexContent.equals(indexTemplate)) {
            UsageStatistics.markAsUsed("routing/client", Version.getFullVersion());
        }
    }
}

