/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.hotswap;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.hotswap.UIUpdateStrategy;
import com.vaadin.flow.internal.BrowserLiveReload;
import com.vaadin.flow.server.VaadinService;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import tools.jackson.databind.JsonNode;

abstract class HotswapEvent {
    protected final VaadinService vaadinService;
    private final Map<UI, UIUpdateStrategy> uiUpdateStrategies = new IdentityHashMap<UI, UIUpdateStrategy>();
    private final List<ClientCommand> clientCommands = new ArrayList<ClientCommand>();
    private UIUpdateStrategy globalUIUpdateStrategy;

    public HotswapEvent(VaadinService vaadinService) {
        this.vaadinService = Objects.requireNonNull(vaadinService, "VaadinService cannot be null");
    }

    public final void triggerUpdate(UIUpdateStrategy uiUpdateStrategy) {
        Objects.requireNonNull(uiUpdateStrategy, "UI update strategy cannot be null");
        if (this.globalUIUpdateStrategy != UIUpdateStrategy.RELOAD) {
            this.globalUIUpdateStrategy = uiUpdateStrategy;
        }
    }

    public final void triggerUpdate(UI ui, UIUpdateStrategy uiUpdateStrategy) {
        Objects.requireNonNull(ui, "UI cannot be null");
        Objects.requireNonNull(uiUpdateStrategy, "UI update strategy cannot be null");
        this.uiUpdateStrategies.compute(ui, (k, existing) -> {
            if (existing == UIUpdateStrategy.RELOAD) {
                return UIUpdateStrategy.RELOAD;
            }
            return uiUpdateStrategy;
        });
    }

    public final void updateClientResource(String path, String content) {
        if (path == null || path.isBlank()) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        this.clientCommands.add(new ClientResource(path, content));
    }

    public final void sendHmrEvent(String event, JsonNode eventData) {
        if (event == null || event.isBlank()) {
            throw new IllegalArgumentException("event cannot be null or empty");
        }
        this.clientCommands.add(new HmrEvent(event, eventData));
    }

    public final VaadinService getVaadinService() {
        return this.vaadinService;
    }

    public boolean requiresPageReload() {
        return this.globalUIUpdateStrategy == UIUpdateStrategy.RELOAD;
    }

    public boolean anyUIRequiresPageReload() {
        return this.globalUIUpdateStrategy == UIUpdateStrategy.RELOAD || this.uiUpdateStrategies.containsValue((Object)UIUpdateStrategy.RELOAD);
    }

    public final Optional<UIUpdateStrategy> getUIUpdateStrategy(UI ui) {
        return Optional.ofNullable(this.uiUpdateStrategies.get(ui)).or(() -> Optional.ofNullable(this.globalUIUpdateStrategy));
    }

    final void applyClientCommands(BrowserLiveReload browserLiveReload) {
        this.clientCommands.forEach(update -> update.apply(browserLiveReload));
    }

    void merge(HotswapEvent event) {
        if (event.globalUIUpdateStrategy != null) {
            this.triggerUpdate(event.globalUIUpdateStrategy);
        }
        event.uiUpdateStrategies.forEach(this::triggerUpdate);
        this.clientCommands.addAll(event.clientCommands);
    }

    private record ClientResource(String path, String content) implements ClientCommand
    {
        @Override
        public void apply(BrowserLiveReload browserLiveReload) {
            browserLiveReload.update(this.path, this.content);
        }
    }

    private record HmrEvent(String event, JsonNode eventData) implements ClientCommand
    {
        @Override
        public void apply(BrowserLiveReload browserLiveReload) {
            browserLiveReload.sendHmrEvent(this.event, this.eventData);
        }
    }

    private static interface ClientCommand {
        public void apply(BrowserLiveReload var1);
    }
}

