/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DisabledUpdateMode;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ReturnChannelMap;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

public class ReturnChannelHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "channel";
    }

    @Override
    protected Optional<Runnable> handleNode(StateNode node, JsonNode invocationJson) {
        int channelId = invocationJson.get("channel").intValue();
        ArrayNode arguments = (ArrayNode)invocationJson.get("args");
        if (!node.hasFeature(ReturnChannelMap.class)) {
            ReturnChannelHandler.getLogger().warn("Node has no return channels: {}", (Object)invocationJson);
            return Optional.empty();
        }
        ReturnChannelRegistration channel = node.getFeatureIfInitialized(ReturnChannelMap.class).map(map -> map.get(channelId)).orElse(null);
        if (channel == null) {
            ReturnChannelHandler.getLogger().warn("Return channel not found: {}", (Object)invocationJson);
            return Optional.empty();
        }
        if (!node.isEnabled() && channel.getDisabledUpdateMode() != DisabledUpdateMode.ALWAYS) {
            ReturnChannelHandler.getLogger().warn("Ignoring update for disabled return channel: {}", (Object)invocationJson);
            return Optional.empty();
        }
        channel.invoke(arguments);
        return Optional.empty();
    }

    @Override
    protected boolean allowInert(UI ui, JsonNode invocationJson) {
        StateNode node = ui.getInternals().getStateTree().getNodeById(ReturnChannelHandler.getNodeId(invocationJson));
        return node.getFeatureIfInitialized(ReturnChannelMap.class).map(ReturnChannelMap::hasChannels).orElse(false);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)ReturnChannelHandler.class.getName());
    }
}

