/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.router.InvalidLocationException;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ErrorHandler;
import com.vaadin.flow.server.ErrorHandlerUtil;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class DefaultErrorHandler
implements ErrorHandler {
    public static final Set<String> SOCKET_EXCEPTIONS = Collections.unmodifiableSet(Set.of(SocketException.class.getName(), SocketTimeoutException.class.getName(), EOFException.class.getName(), "org.eclipse.jetty.io.EofException", "org.apache.catalina.connector.ClientAbortException"));
    private final Set<String> ignoredExceptions;
    private final Set<String> routeConfigurationExceptions;

    protected DefaultErrorHandler(Set<String> ignoredExceptions) {
        this.ignoredExceptions = Set.copyOf(ignoredExceptions);
        this.routeConfigurationExceptions = new HashSet<String>();
    }

    protected DefaultErrorHandler(Set<String> ignoredExceptions, Set<String> routeConfigurationExceptions) {
        this.ignoredExceptions = Set.copyOf(ignoredExceptions);
        this.routeConfigurationExceptions = Set.copyOf(routeConfigurationExceptions);
    }

    public DefaultErrorHandler() {
        this.ignoredExceptions = SOCKET_EXCEPTIONS;
        this.routeConfigurationExceptions = Set.of(AmbiguousRouteConfigurationException.class.getName(), InvalidRouteConfigurationException.class.getName(), InvalidRouteLayoutConfigurationException.class.getName());
    }

    @Override
    public void error(ErrorEvent event) {
        Throwable throwable = DefaultErrorHandler.findRelevantThrowable(event.getThrowable());
        if (this.shouldHandle(throwable)) {
            if (ErrorHandlerUtil.handleErrorByRedirectingToErrorView(throwable)) {
                return;
            }
            Marker marker = MarkerFactory.getMarker((String)"INVALID_LOCATION");
            if (throwable instanceof InvalidLocationException) {
                if (DefaultErrorHandler.getLogger().isWarnEnabled(marker)) {
                    DefaultErrorHandler.getLogger().warn(marker, "Invalid location: {}", (Object)throwable.getMessage(), (Object)throwable);
                }
            } else if (this.routeConfigurationExceptions.contains(throwable.getClass().getName())) {
                DefaultErrorHandler.getLogger().error("Route configuration error found:");
                DefaultErrorHandler.getLogger().error(throwable.getMessage());
            } else {
                DefaultErrorHandler.getLogger().error("Unexpected error: {}", (Object)throwable.getMessage(), (Object)throwable);
            }
        }
    }

    protected boolean shouldHandle(Throwable t) {
        return DefaultErrorHandler.getLogger().isDebugEnabled() || !this.ignoredExceptions.contains(t.getClass().getName());
    }

    public static Throwable findRelevantThrowable(Throwable t) {
        return t;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)DefaultErrorHandler.class.getName());
    }
}

