/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.installer.Platform;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.LoggerFactory;
import tools.jackson.databind.JsonNode;

public class Options
implements Serializable {
    private String buildDirectoryName;
    private ClassFinder classFinder;
    private File frontendDirectory;
    private File webappResourcesDirectory = null;
    private File resourceOutputDirectory = null;
    private boolean enablePackagesUpdate = false;
    private boolean createMissingPackageJson = false;
    private boolean enableImportsUpdate = false;
    private boolean enableConfigUpdate = false;
    private boolean runNpmInstall = false;
    private boolean bundleBuild = false;
    private Set<File> jarFiles = null;
    private boolean generateEmbeddableWebComponents = true;
    private boolean cleanNpmFiles = false;
    private File jarFrontendResourcesFolder = null;
    private File localResourcesFolder = null;
    private boolean useByteCodeScanner = false;
    private JsonNode tokenFileData;
    private File tokenFile;
    private boolean enablePnpm = false;
    private boolean enableBun = false;
    private boolean ciBuild;
    private boolean forceProductionBuild;
    private boolean useGlobalPnpm = false;
    private File frontendGeneratedFolder;
    private boolean requireHomeNodeExec;
    private boolean copyTemplates = false;
    private File npmFolder;
    private boolean skipDevBundle = false;
    private boolean compressBundle = true;
    private List<String> frontendExtraFileExtensions = null;
    private FrontendDependenciesScanner frontendDependenciesScanner;
    private boolean copyAssets = true;
    private String nodeVersion = "v24.10.0";
    private URI nodeDownloadRoot = URI.create(Platform.guess().getNodeDownloadRoot());
    private Lookup lookup;
    private boolean productionMode = true;
    private File javaResourceFolder;
    private File resourcesDirectory;
    private List<String> postinstallPackages = new ArrayList<String>();
    private FeatureFlags featureFlags;
    private boolean frontendHotdeploy = false;
    private boolean reactEnable = true;
    private boolean npmExcludeWebComponents = false;
    private boolean cleanOldGeneratedFiles = false;
    private boolean frontendIgnoreVersionChecks = false;
    private boolean commercialBannerEnabled = false;

    public Options(Lookup lookup, File npmFolder) {
        this(lookup, new ClassFinder.CachedClassFinder(lookup.lookup(ClassFinder.class)), npmFolder);
    }

    public Options(Lookup lookup, ClassFinder classFinder, File npmFolder) {
        this.lookup = lookup;
        this.classFinder = classFinder;
        this.npmFolder = npmFolder;
    }

    public Options withFrontendDirectory(File frontendDirectory) {
        this.frontendDirectory = frontendDirectory.isAbsolute() ? frontendDirectory : new File(this.npmFolder, frontendDirectory.getPath());
        return this;
    }

    public Options withBuildDirectory(String buildDirectory) {
        this.buildDirectoryName = buildDirectory;
        return this;
    }

    public Options withBuildResultFolders(File webappResourcesDirectory, File resourceOutputDirectory) {
        this.enableConfigUpdate = true;
        this.webappResourcesDirectory = webappResourcesDirectory;
        this.resourceOutputDirectory = resourceOutputDirectory;
        return this;
    }

    public Options enablePackagesUpdate(boolean enablePackagesUpdate) {
        this.enablePackagesUpdate = enablePackagesUpdate;
        return this;
    }

    Options enableNpmFileCleaning(boolean forceClean) {
        this.cleanNpmFiles = forceClean;
        return this;
    }

    public Options enableImportsUpdate(boolean enableImportsUpdate) {
        this.enableImportsUpdate = enableImportsUpdate;
        this.createMissingPackageJson = enableImportsUpdate || this.createMissingPackageJson;
        return this;
    }

    public Options withRunNpmInstall(boolean runNpmInstall) {
        this.runNpmInstall = runNpmInstall;
        return this;
    }

    public Options withJarFrontendResourcesFolder(File jarFrontendResourcesFolder) {
        this.jarFrontendResourcesFolder = jarFrontendResourcesFolder.isAbsolute() ? jarFrontendResourcesFolder : new File(this.npmFolder, jarFrontendResourcesFolder.getPath());
        return this;
    }

    public Options copyResources(Set<File> jars) {
        Objects.requireNonNull(jars, "Parameter 'jars' must not be null!");
        this.jarFiles = jars;
        return this;
    }

    public Options withCopyTemplates(boolean copyTemplates) {
        this.copyTemplates = copyTemplates;
        return this;
    }

    public Options withEmbeddableWebComponents(boolean generateEmbeddableWebComponents) {
        this.generateEmbeddableWebComponents = generateEmbeddableWebComponents;
        return this;
    }

    public Options createMissingPackageJson(boolean create) {
        this.createMissingPackageJson = create;
        return this;
    }

    public Options copyLocalResources(File localResourcesFolder) {
        this.localResourcesFolder = localResourcesFolder;
        return this;
    }

    public Options withFrontendGeneratedFolder(File frontendGeneratedFolder) {
        this.frontendGeneratedFolder = frontendGeneratedFolder;
        return this;
    }

    public File getFrontendGeneratedFolder() {
        if (this.frontendGeneratedFolder == null) {
            return new File(this.getFrontendDirectory(), "generated/");
        }
        return this.frontendGeneratedFolder;
    }

    public Options useByteCodeScanner(boolean byteCodeScanner) {
        this.useByteCodeScanner = byteCodeScanner;
        return this;
    }

    public Options populateTokenFileData(JsonNode object) {
        this.tokenFileData = object;
        return this;
    }

    public Options withTokenFile(File tokenFile) {
        this.tokenFile = tokenFile;
        return this;
    }

    public Options withEnablePnpm(boolean enable) {
        this.enablePnpm = enable;
        return this;
    }

    public Options withEnableBun(boolean enable) {
        this.enableBun = enable;
        return this;
    }

    public Options withCiBuild(boolean ciBuild) {
        this.ciBuild = ciBuild;
        return this;
    }

    public Options withForceProductionBuild(boolean forceProductionBuild) {
        this.forceProductionBuild = forceProductionBuild;
        return this;
    }

    public Options useGlobalPnpm(boolean useGlobalPnpm) {
        this.useGlobalPnpm = useGlobalPnpm;
        return this;
    }

    public Options withHomeNodeExecRequired(boolean requireHomeNodeExec) {
        this.requireHomeNodeExec = requireHomeNodeExec;
        return this;
    }

    public Options withNodeVersion(String nodeVersion) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion);
        return this;
    }

    public Options withNodeDownloadRoot(URI nodeDownloadRoot) {
        this.nodeDownloadRoot = Objects.requireNonNull(nodeDownloadRoot);
        return this;
    }

    public Options withProductionMode(boolean productionMode) {
        this.productionMode = productionMode;
        return this;
    }

    public Options withFrontendHotdeploy(boolean frontendHotdeploy) {
        this.frontendHotdeploy = frontendHotdeploy;
        return this;
    }

    public Options withFrontendIgnoreVersionChecks(boolean frontendIgnoreVersionChecks) {
        this.frontendIgnoreVersionChecks = frontendIgnoreVersionChecks;
        return this;
    }

    public boolean isFrontendHotdeploy() {
        return this.frontendHotdeploy;
    }

    public boolean isDevBundleBuild() {
        return !this.isProductionMode() && this.isBundleBuild();
    }

    public Options withBundleBuild(boolean bundleBuild) {
        this.bundleBuild = bundleBuild;
        return this;
    }

    public boolean isBundleBuild() {
        return this.bundleBuild;
    }

    public Options setJavaResourceFolder(File javaResourceFolder) {
        this.javaResourceFolder = javaResourceFolder;
        return this;
    }

    public Options withPostinstallPackages(List<String> postinstallPackages) {
        this.postinstallPackages = postinstallPackages;
        return this;
    }

    public File getNpmFolder() {
        return this.npmFolder;
    }

    public File getWebappResourcesDirectory() {
        return this.webappResourcesDirectory;
    }

    public File getFrontendDirectory() {
        if (this.frontendDirectory == null && this.npmFolder != null) {
            return new File(this.npmFolder, System.getProperty("vaadin.frontend.folder", "./src/main/frontend/"));
        }
        return this.frontendDirectory;
    }

    public String getBuildDirectoryName() {
        return this.buildDirectoryName;
    }

    public File getBuildDirectory() {
        return new File(this.npmFolder, this.getBuildDirectoryName());
    }

    public Options withFeatureFlags(FeatureFlags featureFlags) {
        this.featureFlags = featureFlags;
        return this;
    }

    public FeatureFlags getFeatureFlags() {
        if (this.featureFlags == null) {
            this.featureFlags = new FeatureFlags(this.lookup);
            if (this.javaResourceFolder != null) {
                this.featureFlags.setPropertiesLocation(this.javaResourceFolder);
            }
        }
        return this.featureFlags;
    }

    public File getJarFrontendResourcesFolder() {
        return this.jarFrontendResourcesFolder;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public File getNodeModulesFolder() {
        return new File(this.getNpmFolder(), "node_modules/");
    }

    public File getResourceOutputDirectory() {
        return this.resourceOutputDirectory;
    }

    public boolean isEnablePackagesUpdate() {
        return this.enablePackagesUpdate;
    }

    public boolean isCreateMissingPackageJson() {
        return this.createMissingPackageJson;
    }

    public boolean isEnableImportsUpdate() {
        return this.enableImportsUpdate;
    }

    public boolean isEnableConfigUpdate() {
        return this.enableConfigUpdate;
    }

    public boolean isRunNpmInstall() {
        return this.runNpmInstall;
    }

    public Set<File> getJarFiles() {
        return this.jarFiles;
    }

    public boolean isGenerateEmbeddableWebComponents() {
        return this.generateEmbeddableWebComponents;
    }

    @Deprecated(since="25.0", forRemoval=true)
    public boolean isCleanNpmFiles() {
        return this.cleanNpmFiles;
    }

    public File getLocalResourcesFolder() {
        return this.localResourcesFolder;
    }

    public boolean isUseByteCodeScanner() {
        return this.useByteCodeScanner;
    }

    public JsonNode getTokenFileData() {
        return this.tokenFileData;
    }

    public File getTokenFile() {
        return this.tokenFile;
    }

    public boolean isEnablePnpm() {
        return this.enablePnpm;
    }

    public boolean isEnableBun() {
        return this.enableBun;
    }

    public boolean isCiBuild() {
        return this.ciBuild;
    }

    public boolean isForceProductionBuild() {
        return this.forceProductionBuild;
    }

    public boolean isUseGlobalPnpm() {
        return this.useGlobalPnpm;
    }

    public boolean isRequireHomeNodeExec() {
        return this.requireHomeNodeExec;
    }

    public boolean isCopyTemplates() {
        return this.copyTemplates;
    }

    public String getNodeVersion() {
        return this.nodeVersion;
    }

    public URI getNodeDownloadRoot() {
        return this.nodeDownloadRoot;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public boolean isProductionMode() {
        return this.productionMode;
    }

    public File getJavaResourceFolder() {
        return this.javaResourceFolder;
    }

    public List<String> getPostinstallPackages() {
        return this.postinstallPackages;
    }

    public Options skipDevBundleBuild(boolean skip) {
        this.skipDevBundle = skip;
        return this;
    }

    public boolean isSkipDevBundle() {
        return this.skipDevBundle;
    }

    public Options withCompressBundle(boolean compressBundle) {
        this.compressBundle = compressBundle;
        return this;
    }

    public boolean isCompressBundle() {
        return this.compressBundle;
    }

    public boolean isReactEnabled() {
        return this.reactEnable;
    }

    public Options withReact(boolean reactEnable) {
        this.reactEnable = reactEnable;
        if (reactEnable && !FrontendUtils.isReactRouterRequired(this.getFrontendDirectory())) {
            LoggerFactory.getLogger(Options.class).debug("Setting reactEnable to false as Vaadin Router is used!");
            this.reactEnable = false;
        }
        return this;
    }

    public Options withCleanOldGeneratedFiles(boolean clean) {
        this.cleanOldGeneratedFiles = clean;
        return this;
    }

    public boolean isCleanOldGeneratedFiles() {
        return this.cleanOldGeneratedFiles;
    }

    public Options withFrontendExtraFileExtensions(List<String> frontendExtraFileExtensions) {
        this.frontendExtraFileExtensions = frontendExtraFileExtensions;
        return this;
    }

    public List<String> getFrontendExtraFileExtensions() {
        return this.frontendExtraFileExtensions;
    }

    public boolean isNpmExcludeWebComponents() {
        return this.npmExcludeWebComponents;
    }

    public Options withNpmExcludeWebComponents(boolean exclude) {
        this.npmExcludeWebComponents = exclude;
        return this;
    }

    public boolean isFrontendIgnoreVersionChecks() {
        return this.frontendIgnoreVersionChecks;
    }

    public Options withFrontendDependenciesScanner(FrontendDependenciesScanner frontendDependenciesScanner) {
        this.frontendDependenciesScanner = frontendDependenciesScanner;
        return this;
    }

    public boolean isCommercialBannerEnabled() {
        return this.commercialBannerEnabled;
    }

    public Options withCommercialBanner(boolean enableCommercialBanner) {
        this.commercialBannerEnabled = enableCommercialBanner;
        return this;
    }

    public FrontendDependenciesScanner getFrontendDependenciesScanner() {
        if (this.frontendDependenciesScanner == null) {
            boolean reactEnabled = this.isReactEnabled() && FrontendUtils.isReactRouterRequired(this.getFrontendDirectory());
            this.frontendDependenciesScanner = new FrontendDependenciesScanner.FrontendDependenciesScannerFactory().createScanner(!this.isUseByteCodeScanner(), this.getClassFinder(), this.isGenerateEmbeddableWebComponents(), this.getFeatureFlags(), reactEnabled);
        }
        return this.frontendDependenciesScanner;
    }

    public Options setCopyAssets(boolean copyAssets) {
        this.copyAssets = copyAssets;
        return this;
    }

    public boolean copyAssets() {
        if (this.isDevBundleBuild()) {
            return true;
        }
        return this.copyAssets;
    }

    public Options withMetaInfResourcesDirectory(File resourcesDirectory) {
        this.resourcesDirectory = resourcesDirectory;
        return this;
    }

    public File getMetaInfResourcesDirectory() {
        return this.resourcesDirectory;
    }
}

