/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.frontend.CompressionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class CompressUtil {
    private CompressUtil() {
    }

    public static void compressDirectory(File targetDirectory, File outfile) {
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(outfile));){
            for (File child : targetDirectory.listFiles()) {
                CompressUtil.zip(child, child.getName(), zipOut);
            }
        }
        catch (IOException e) {
            throw new CompressionException("Failed to compress bundle files to '" + outfile.getPath() + "'", e);
        }
    }

    private static void zip(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        fileName = ((String)fileName).replaceAll("\\\\", "/");
        if (fileToZip.isDirectory()) {
            if (!((String)fileName).endsWith("/")) {
                fileName = (String)fileName + "/";
            }
            zipOut.putNextEntry(new ZipEntry((String)fileName));
            zipOut.closeEntry();
            for (File child : fileToZip.listFiles()) {
                CompressUtil.zip(child, (String)fileName + child.getName(), zipOut);
            }
            return;
        }
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            int length;
            ZipEntry zipEntry = new ZipEntry((String)fileName);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
        }
        zipOut.closeEntry();
    }

    public static void uncompressFile(File zip, File targetDirectory) {
        if (!zip.exists()) {
            return;
        }
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zip));){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = CompressUtil.newFile(targetDirectory, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(newFile));
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(parent));
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
        }
        catch (IOException e) {
            throw new CompressionException("Failed to unpack '" + zip.getPath() + "'", e);
        }
    }

    private static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readFileContentFromZip(File zip, String filename) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            String string;
            block15: {
                ZipEntry entry = zipFile.getEntry(filename);
                if (entry == null) {
                    String string2 = null;
                    return string2;
                }
                InputStream inputStream = zipFile.getInputStream(entry);
                try {
                    string = StringUtil.toUTF8String(inputStream);
                    if (inputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return string;
        }
        catch (ZipException e) {
            throw new IOException(e);
        }
    }
}

