/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.hotswap.HotswapClassEvent;
import com.vaadin.flow.hotswap.HotswapClassSessionEvent;
import com.vaadin.flow.hotswap.VaadinHotswapper;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.SessionRouteRegistry;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TaskGenerateReactFiles;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;

public class RouteRegistryHotswapper
implements VaadinHotswapper {
    @Override
    public void onClassesChange(HotswapClassEvent event) {
        boolean redefined = event.isRedefined();
        Set<Class<?>> classes = event.getChangedClasses();
        Set<Class<?>> addedClasses = redefined ? Set.of() : classes;
        Set<Class<Object>> modifiedClasses = redefined ? classes : Set.of();
        Set<Class<?>> removedClasses = Set.of();
        VaadinService vaadinService = event.getVaadinService();
        if (this.hasComponentClasses(addedClasses, modifiedClasses, removedClasses)) {
            ApplicationRouteRegistry appRegistry = ApplicationRouteRegistry.getInstance(vaadinService.getContext());
            HashSet layouts = new HashSet(appRegistry.getLayouts());
            RouteUtil.updateRouteRegistry(appRegistry, addedClasses, modifiedClasses, removedClasses);
            layouts.addAll(appRegistry.getLayouts());
            DeploymentConfiguration configuration = vaadinService.getDeploymentConfiguration();
            if (configuration.isReactEnabled()) {
                if (Stream.of(addedClasses, modifiedClasses, removedClasses).flatMap(Collection::stream).anyMatch(layouts::contains)) {
                    Options options = new Options(vaadinService.getContext().getAttribute(Lookup.class), null, configuration.getProjectFolder()).withFrontendDirectory(configuration.getFrontendFolder());
                    TaskGenerateReactFiles.writeLayouts(options, appRegistry.getLayouts());
                }
            }
        }
    }

    @Override
    public void onClassesChange(HotswapClassSessionEvent event) {
        boolean redefined = event.isRedefined();
        Set<Class<?>> classes = event.getChangedClasses();
        VaadinSession session = event.getVaadinSession();
        Set<Object> addedClasses = redefined ? Set.of() : classes;
        Set<Class<Object>> modifiedClasses = redefined ? classes : Set.of();
        Set<Class<?>> removedClasses = Set.of();
        if (session.getAttribute(SessionRouteRegistry.class) != null && this.hasComponentClasses(addedClasses, modifiedClasses, removedClasses)) {
            RouteUtil.updateRouteRegistry(SessionRouteRegistry.getSessionRegistry(session), Set.of(), modifiedClasses, removedClasses);
        }
    }

    @SafeVarargs
    private boolean hasComponentClasses(Set<Class<?>> ... classes) {
        return Stream.of(classes).filter(classSet -> classSet != null && !classSet.isEmpty()).flatMap(Collection::stream).anyMatch(Component.class::isAssignableFrom);
    }
}

