/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouteUtil;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.AnnotationValidator;
import com.vaadin.flow.server.startup.DuplicateNavigationTitleException;
import com.vaadin.flow.server.startup.WebComponentExporterAwareValidator;
import jakarta.servlet.annotation.HandlesTypes;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractRouteRegistryInitializer
implements Serializable {
    private Class<?> pwaClass = null;

    protected Set<Class<? extends Component>> validateRouteClasses(VaadinContext context, Stream<Class<?>> routeClasses) {
        return routeClasses.peek(clazz -> this.checkForConflictingAnnotations(context, (Class<?>)clazz)).filter(this::isApplicableClass).map(target -> target).collect(Collectors.toSet());
    }

    private boolean isApplicableClass(Class<?> clazz) {
        boolean hasRouteAnnotation = clazz.isAnnotationPresent(Route.class);
        if (hasRouteAnnotation && !Component.class.isAssignableFrom(clazz)) {
            throw new InvalidRouteConfigurationException(String.format("'%s' declares '@%s' but does not extend '%s'.", clazz.getCanonicalName(), Route.class.getSimpleName(), Component.class.getCanonicalName()));
        }
        return hasRouteAnnotation && clazz.getAnnotation(Route.class).registerAtStartup();
    }

    private void checkForConflictingAnnotations(VaadinContext context, Class<?> route) {
        if (route.isAnnotationPresent(RouteAlias.class) && !route.isAnnotationPresent(Route.class)) {
            throw new InvalidRouteLayoutConfigurationException(String.format("'%s' declares '@%s' but doesn't declare '@%s'. The '%s' may not be used without '%s'", route.getCanonicalName(), RouteAlias.class.getSimpleName(), Route.class.getSimpleName(), RouteAlias.class.getSimpleName(), Route.class.getSimpleName()));
        }
        RouteAlias[] aliases = (RouteAlias[])route.getAnnotationsByType(RouteAlias.class);
        if (aliases.length > 0) {
            String routePath = RouteUtil.getRoutePath(context, route);
            Map stats = Arrays.stream(aliases).map(ann -> RouteUtil.getRouteAliasPath(route, ann)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            if (stats.containsKey(routePath)) {
                throw new InvalidRouteConfigurationException(String.format("'%s' declares '@%s' and '@%s' with the same path '%s'. Make sure paths are different by checking annotation values and prefixes defined by layouts", route.getCanonicalName(), Route.class.getSimpleName(), RouteAlias.class.getSimpleName(), routePath));
            }
            String repeatedAliases = stats.entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(", "));
            if (!repeatedAliases.isEmpty()) {
                throw new InvalidRouteConfigurationException(String.format("'%s' declares multiple '@%s' with same paths: %s.Make sure paths are different by checking annotation values and prefixes defined by layouts.", route.getCanonicalName(), RouteAlias.class.getSimpleName(), repeatedAliases));
            }
        }
        if (route.isAnnotationPresent(PageTitle.class) && HasDynamicTitle.class.isAssignableFrom(route)) {
            throw new DuplicateNavigationTitleException(String.format("'%s' has a PageTitle annotation, but also implements HasDynamicTitle.", route.getName()));
        }
        this.getValidationAnnotations().forEach(type -> {
            Class<Annotation> annotation = type.asSubclass(Annotation.class);
            this.validateRouteAnnotation(context, route, annotation);
            for (RouteAlias alias : aliases) {
                this.validateRouteAliasAnnotation(context, route, alias, annotation);
            }
        });
        this.validateRouteParentLayout(route);
    }

    private Stream<Class<?>> getValidationAnnotations() {
        return Stream.concat(Stream.of(AnnotationValidator.class.getAnnotation(HandlesTypes.class).value()), Stream.of(WebComponentExporterAwareValidator.class.getAnnotation(HandlesTypes.class).value()));
    }

    private void validateRouteParentLayout(Class<?> route) {
        Route annotation = route.getAnnotation(Route.class);
        ParentLayout parentLayout = route.getAnnotation(ParentLayout.class);
        if (annotation == null || parentLayout == null) {
            return;
        }
        if (!RouterLayout.class.isAssignableFrom(route)) {
            throw new InvalidRouteLayoutConfigurationException(String.format("The class '%s' should either be a '%s' or only a navigation target using '%s.layout' to set the parent layout", route.getSimpleName(), RouterLayout.class.getSimpleName(), Route.class.getSimpleName()));
        }
    }

    private void validateRouteAnnotation(VaadinContext context, Class<?> route, Class<? extends Annotation> annotation) {
        Route routeAnnotation = route.getAnnotation(Route.class);
        if (routeAnnotation != null && !UI.class.equals(routeAnnotation.layout())) {
            if (route.isAnnotationPresent(annotation)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s annotation needs to be on the top parent layout '%s' not on '%s'", annotation.getSimpleName(), RouteUtil.getTopParentLayout(context, route, RouteUtil.resolve(context, route)).getName(), route.getName()));
            }
            List<Class<? extends RouterLayout>> parentLayouts = RouteUtil.getParentLayouts(context, route, RouteUtil.resolve(context, route));
            Class<? extends RouterLayout> topParentLayout = RouteUtil.getTopParentLayout(context, route, RouteUtil.resolve(context, route));
            this.validateParentAnnotation(parentLayouts, topParentLayout, annotation);
        }
    }

    private void validateRouteAliasAnnotation(VaadinContext context, Class<?> route, RouteAlias alias, Class<? extends Annotation> annotation) {
        if (!UI.class.equals(alias.layout())) {
            if (route.isAnnotationPresent(annotation)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s annotation needs to be on the top parent layout '%s' not on '%s'", annotation.getSimpleName(), RouteUtil.getTopParentLayout(context, route, alias.value()).getName(), route.getName()));
            }
            List<Class<? extends RouterLayout>> parentLayouts = RouteUtil.getParentLayouts(context, route, alias.value());
            Class<? extends RouterLayout> topParentLayout = RouteUtil.getTopParentLayout(context, route, alias.value());
            this.validateParentAnnotation(parentLayouts, topParentLayout, annotation);
        }
    }

    private void validateParentAnnotation(List<Class<? extends RouterLayout>> parentLayouts, Class<? extends RouterLayout> topParentLayout, Class<? extends Annotation> annotation) {
        Supplier<Stream> streamSupplier = () -> parentLayouts.stream().filter(layout -> layout.isAnnotationPresent(annotation));
        if (streamSupplier.get().count() > 1L) {
            throw new InvalidRouteLayoutConfigurationException("Only one " + annotation.getSimpleName() + " annotation is supported for navigation chain and should be on the top most level. Offending classes in chain: " + streamSupplier.get().map(Class::getName).collect(Collectors.joining(", ")));
        }
        streamSupplier.get().findFirst().ifPresent(layout -> {
            if (!layout.equals(topParentLayout)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s annotation should be on the top most route layout '%s'. Offending class: '%s'", annotation.getSimpleName(), topParentLayout.getName(), layout.getName()));
            }
        });
    }

    protected Class<?> validatePwaClass(VaadinContext context, Stream<Class<?>> routeClasses) {
        this.pwaClass = null;
        routeClasses.forEach(route -> {
            this.validatePwa((Class<?>)route);
            Route routeAnnotation = route.getAnnotation(Route.class);
            if (!UI.class.equals(routeAnnotation.layout())) {
                Class<? extends RouterLayout> topParentLayout = RouteUtil.getTopParentLayout(context, route, RouteUtil.resolve(context, route));
                this.validatePwa(topParentLayout);
            }
        });
        return this.pwaClass;
    }

    private void validatePwa(Class<?> pwaClassCandidate) {
        if (pwaClassCandidate == null || !pwaClassCandidate.isAnnotationPresent(PWA.class)) {
            return;
        }
        if (this.pwaClass != null && this.pwaClass != pwaClassCandidate) {
            throw new InvalidRouteLayoutConfigurationException(String.format("Expected only one '%s' annotation that is placed on the main layout of the application. Got multiple annotations in '%s' and '%s'", PWA.class.getSimpleName(), this.pwaClass.getSimpleName(), pwaClassCandidate.getSimpleName()));
        }
        this.pwaClass = pwaClassCandidate;
    }
}

