/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.dom.ChildElementConsumer;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.AttachExistingElementFeature;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import java.util.Optional;
import tools.jackson.databind.JsonNode;

public class AttachExistingElementRpcHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "attachExistingElement";
    }

    @Override
    protected Optional<Runnable> handleNode(StateNode node, JsonNode invocationJson) {
        assert (invocationJson.has("attachReqId"));
        assert (invocationJson.has("attachAssignedId"));
        assert (invocationJson.has("attachTagName"));
        assert (invocationJson.has("attachIndex"));
        int requestedId = invocationJson.get("attachReqId").intValue();
        int assignedId = invocationJson.get("attachAssignedId").intValue();
        String tag = invocationJson.get("attachTagName").asString();
        int index = invocationJson.get("attachIndex").intValue();
        AttachExistingElementFeature feature = node.getFeature(AttachExistingElementFeature.class);
        StateTree tree = (StateTree)node.getOwner();
        StateNode requestedNode = tree.getNodeById(requestedId);
        if (assignedId == -1) {
            assert (index == -1);
            ChildElementConsumer callback = feature.getCallback(requestedNode);
            assert (callback != null);
            callback.onError(feature.getParent(requestedNode), tag, feature.getPreviousSibling(requestedNode));
            feature.unregister(requestedNode);
        } else {
            Element element = Element.get(tree.getNodeById(assignedId));
            this.attachElement(feature, element, index, tree.getNodeById(requestedId), requestedId == assignedId);
        }
        return Optional.empty();
    }

    private void attachElement(AttachExistingElementFeature feature, Element element, int index, StateNode node, boolean insertChild) {
        ChildElementConsumer callback = feature.getCallback(node);
        if (callback != null) {
            Node<?> parent = feature.getParent(node);
            feature.unregister(node);
            if (insertChild) {
                parent.insertChild(index, element);
            }
            callback.accept(element);
        }
    }
}

