/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Function;

public class AccessAnnotationChecker
implements Serializable {
    public boolean hasAccess(Method method) {
        VaadinServletRequest request = VaadinServletRequest.getCurrent();
        if (request == null) {
            throw new IllegalStateException("No request is available. This method can only be used with an active VaadinServletRequest");
        }
        return this.hasAccess(method, (HttpServletRequest)request);
    }

    public boolean hasAccess(Class<?> cls) {
        VaadinServletRequest request = VaadinServletRequest.getCurrent();
        if (request == null) {
            throw new IllegalStateException("No request is available. This method can only be used with an active VaadinServletRequest");
        }
        return this.hasAccess(cls, (HttpServletRequest)request);
    }

    public boolean hasAccess(Method method, HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("The request cannot be null");
        }
        return this.hasAccess(method, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
    }

    public boolean hasAccess(Class<?> cls, HttpServletRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("The request cannot be null");
        }
        return this.hasAccess(cls, request.getUserPrincipal(), arg_0 -> ((HttpServletRequest)request).isUserInRole(arg_0));
    }

    public boolean hasAccess(Method method, Principal principal, Function<String, Boolean> roleChecker) {
        return this.hasAccess(this.getSecurityTarget(method), principal, roleChecker);
    }

    public boolean hasAccess(Class<?> cls, Principal principal, Function<String, Boolean> roleChecker) {
        return this.hasAccess(this.getSecurityTarget(cls), principal, roleChecker);
    }

    public AnnotatedElement getSecurityTarget(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException(String.format("The method '%s' is not public hence cannot have a security target", method));
        }
        return AccessAnnotationChecker.hasSecurityAnnotation(method) ? method : method.getDeclaringClass();
    }

    public AnnotatedElement getSecurityTarget(Class<?> cls) {
        return AccessAnnotationChecker.securityTarget(cls);
    }

    static AnnotatedElement securityTarget(Class<?> cls) {
        Objects.requireNonNull(cls, "The input Class must not be null.");
        for (Class<?> clazz = cls; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (!AccessAnnotationChecker.hasSecurityAnnotation(clazz)) continue;
            return clazz;
        }
        return cls;
    }

    private boolean hasAccess(AnnotatedElement annotatedClassOrMethod, Principal principal, Function<String, Boolean> roleChecker) {
        if (annotatedClassOrMethod.isAnnotationPresent(DenyAll.class)) {
            return false;
        }
        if (annotatedClassOrMethod.isAnnotationPresent(AnonymousAllowed.class)) {
            return true;
        }
        if (principal == null) {
            return false;
        }
        RolesAllowed rolesAllowed = annotatedClassOrMethod.getAnnotation(RolesAllowed.class);
        if (rolesAllowed == null) {
            return annotatedClassOrMethod.isAnnotationPresent(PermitAll.class);
        }
        return this.roleAllowed(rolesAllowed, roleChecker);
    }

    private boolean roleAllowed(RolesAllowed rolesAllowed, Function<String, Boolean> roleChecker) {
        for (String role : rolesAllowed.value()) {
            if (!roleChecker.apply(role).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSecurityAnnotation(AnnotatedElement method) {
        return method.isAnnotationPresent(AnonymousAllowed.class) || method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(DenyAll.class) || method.isAnnotationPresent(RolesAllowed.class);
    }
}

