/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.RouteBaseData;
import com.vaadin.flow.server.RouteRegistry;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;

public class RoutesChangedEvent
extends EventObject {
    private final List<RouteBaseData<?>> added;
    private final List<RouteBaseData<?>> removed;

    public RoutesChangedEvent(RouteRegistry source, List<RouteBaseData<?>> added, List<RouteBaseData<?>> removed) {
        super(source);
        this.added = Collections.unmodifiableList(added);
        this.removed = Collections.unmodifiableList(removed);
    }

    @Override
    public RouteRegistry getSource() {
        return (RouteRegistry)super.getSource();
    }

    public List<RouteBaseData<?>> getAddedRoutes() {
        return this.added;
    }

    public List<RouteBaseData<?>> getRemovedRoutes() {
        return this.removed;
    }

    public boolean isRouteAdded(Class<? extends Component> clazz) {
        return this.checkIfRouteIsPresent(this.added, clazz);
    }

    public boolean isRouteRemoved(Class<? extends Component> clazz) {
        return this.checkIfRouteIsPresent(this.removed, clazz);
    }

    private boolean checkIfRouteIsPresent(List<RouteBaseData<?>> routes, Class<? extends Component> clazz) {
        return routes.stream().map(RouteBaseData::getNavigationTarget).anyMatch(navigationTarget -> navigationTarget.equals(clazz));
    }

    public boolean isPathAdded(String path) {
        return this.checkIfRouteIsPresent(this.added, path);
    }

    public boolean isPathRemoved(String path) {
        return this.checkIfRouteIsPresent(this.removed, path);
    }

    public List<Class<? extends Component>> getAddedNavigationTargets() {
        return Collections.unmodifiableList(this.added.stream().map(RouteBaseData::getNavigationTarget).collect(Collectors.toList()));
    }

    public List<Class<? extends Component>> getRemovedNavigationTargets() {
        return Collections.unmodifiableList(this.removed.stream().map(RouteBaseData::getNavigationTarget).collect(Collectors.toList()));
    }

    public List<String> getAddedURLs() {
        return Collections.unmodifiableList(this.added.stream().map(RouteBaseData::getTemplate).collect(Collectors.toList()));
    }

    public List<String> getRemovedURLs() {
        return Collections.unmodifiableList(this.removed.stream().map(RouteBaseData::getTemplate).collect(Collectors.toList()));
    }

    private boolean checkIfRouteIsPresent(List<RouteBaseData<?>> routes, String path) {
        return routes.stream().map(RouteBaseData::getTemplate).anyMatch(url -> url.equals(path));
    }
}

