/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import java.nio.charset.StandardCharsets;
import java.util.HexFormat;

public final class EncodeUtil {
    private static final HexFormat HEX_FORMAT = HexFormat.of().withUpperCase();

    private EncodeUtil() {
    }

    public static String rfc5987Encode(String value) {
        int cp;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < value.length(); i += Character.charCount(cp)) {
            cp = value.codePointAt(i);
            if (cp < 127 && EncodeUtil.isRFC5987AttrChar(cp)) {
                builder.append((char)cp);
                continue;
            }
            String cpAsString = new String(new int[]{cp}, 0, 1);
            EncodeUtil.appendHexBytes(builder, cpAsString.getBytes(StandardCharsets.UTF_8));
        }
        return builder.toString();
    }

    private static void appendHexBytes(StringBuilder builder, byte[] bytes) {
        for (byte byteValue : bytes) {
            builder.append('%');
            HEX_FORMAT.toHexDigits(builder, byteValue);
        }
    }

    private static boolean isRFC5987AttrChar(int codePoint) {
        return Character.isLetterOrDigit(codePoint) || "!#$&+-.^_`|~".indexOf(codePoint) >= 0;
    }

    public static String rfc2047Encode(String value) {
        byte[] source = value.getBytes(StandardCharsets.UTF_8);
        StringBuilder sb = new StringBuilder(source.length << 1);
        sb.append("=?").append(StandardCharsets.UTF_8.name()).append("?Q?");
        for (byte b : source) {
            if (b == 32) {
                sb.append('_');
                continue;
            }
            if (EncodeUtil.isPrintable(b)) {
                sb.append((char)b);
                continue;
            }
            sb.append('=');
            HEX_FORMAT.toHexDigits(sb, b);
        }
        sb.append("?=");
        return sb.toString();
    }

    private static boolean isPrintable(byte c) {
        int b = c & 0xFF;
        return b >= 33 && b <= 126 && b != 34 && b != 61 && b != 63 && b != 95;
    }

    public static boolean isPureUSASCII(String text) {
        return StandardCharsets.US_ASCII.newEncoder().canEncode(text);
    }
}

