/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.nodefeature.ReturnChannelRegistration;
import java.io.Serializable;
import tools.jackson.core.TreeNode;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BaseJsonNode;
import tools.jackson.databind.node.JsonNodeType;
import tools.jackson.databind.node.ObjectNode;

public class JacksonCodec {
    private JacksonCodec() {
    }

    public static JsonNode encodeWithTypeInfo(Object value) {
        if (value == null) {
            return JacksonCodec.encodeWithoutTypeInfo(value);
        }
        if (value instanceof ReturnChannelRegistration) {
            return JacksonCodec.encodeReturnChannel((ReturnChannelRegistration)value);
        }
        if (JacksonCodec.canEncodeWithoutTypeInfo(value.getClass())) {
            return JacksonCodec.encodeWithoutTypeInfo(value);
        }
        return JacksonUtils.getMapper().valueToTree(value);
    }

    private static JsonNode encodeReturnChannel(ReturnChannelRegistration value) {
        ObjectMapper mapper = JacksonUtils.getMapper();
        ObjectNode obj = mapper.createObjectNode();
        ArrayNode channelArray = mapper.createArrayNode();
        channelArray.add(value.getStateNodeId());
        channelArray.add(value.getChannelId());
        obj.set("@v-return", (JsonNode)channelArray);
        return obj;
    }

    public static boolean canEncodeWithoutTypeInfo(Class<?> type) {
        assert (type != null);
        return String.class.equals(type) || Integer.class.equals(type) || Double.class.equals(type) || Boolean.class.equals(type) || JsonNode.class.isAssignableFrom(type);
    }

    public static JsonNode encodeWithConstantPool(Object value, ConstantPool constantPool) {
        if (value instanceof ConstantPoolKey) {
            ConstantPoolKey reference = (ConstantPoolKey)value;
            return JacksonUtils.getMapper().valueToTree((Object)constantPool.getConstantId(reference));
        }
        return JacksonCodec.encodeWithoutTypeInfo(value);
    }

    public static JsonNode encodeWithoutTypeInfo(Object value) {
        if (value == null) {
            return JacksonUtils.getMapper().nullNode();
        }
        assert (JacksonCodec.canEncodeWithoutTypeInfo(value.getClass())) : "this:_" + String.valueOf(value.getClass());
        Class<?> type = value.getClass();
        if (String.class.equals(value.getClass())) {
            return JacksonUtils.getMapper().valueToTree(value);
        }
        if (Integer.class.equals(type)) {
            return JacksonUtils.getMapper().valueToTree((Object)((Number)value).intValue());
        }
        if (Double.class.equals(type)) {
            return JacksonUtils.getMapper().valueToTree((Object)((Number)value).doubleValue());
        }
        if (Boolean.class.equals(type)) {
            return JacksonUtils.getMapper().valueToTree((Object)((Boolean)value));
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return (JsonNode)value;
        }
        throw new IllegalArgumentException("Can't encode " + String.valueOf(value.getClass()) + " to json");
    }

    public static Serializable decodeWithoutTypeInfo(BaseJsonNode json) {
        assert (json != null);
        switch (json.getNodeType()) {
            case BOOLEAN: {
                return JacksonCodec.decodeAs((JsonNode)json, Boolean.class);
            }
            case STRING: {
                return (Serializable)((Object)JacksonCodec.decodeAs((JsonNode)json, String.class));
            }
            case NUMBER: {
                return JacksonCodec.decodeAs((JsonNode)json, Double.class);
            }
            case NULL: {
                return null;
            }
        }
        return json;
    }

    public static <T> T decodeAs(JsonNode json, Class<T> type) {
        assert (json != null);
        if (json.getNodeType() == JsonNodeType.NULL && !type.isPrimitive()) {
            return null;
        }
        if (JsonNode.class.isAssignableFrom(type)) {
            return type.cast(json);
        }
        try {
            return (T)JacksonUtils.getMapper().treeToValue((TreeNode)json, type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot deserialize JSON to type " + type.getName() + ": " + e.getMessage(), e);
        }
    }

    public static <T> T decodeAs(JsonNode json, TypeReference<T> typeReference) {
        assert (json != null);
        assert (typeReference != null);
        if (json.getNodeType() == JsonNodeType.NULL) {
            return null;
        }
        try {
            return (T)JacksonUtils.getMapper().treeToValue((TreeNode)json, typeReference);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot deserialize JSON to type " + typeReference.getType().getTypeName() + ": " + e.getMessage(), e);
        }
    }
}

