/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.PendingJavaScriptResult;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.slf4j.LoggerFactory;

public interface WebStorage
extends Serializable {
    public static void setItem(String key, String value) {
        WebStorage.setItem(Storage.LOCAL_STORAGE, key, value);
    }

    public static void setItem(Storage storage, String key, String value) {
        WebStorage.setItem(UI.getCurrentOrThrow(), storage, key, value);
    }

    public static void setItem(UI ui, Storage storage, String key, String value) {
        ui.getPage().executeJs("window[$0].setItem($1,$2)", storage.toString(), key, value);
    }

    public static void removeItem(String key) {
        WebStorage.removeItem(Storage.LOCAL_STORAGE, key);
    }

    public static void removeItem(Storage storage, String key) {
        WebStorage.removeItem(UI.getCurrentOrThrow(), storage, key);
    }

    public static void removeItem(UI ui, Storage storage, String key) {
        ui.getPage().executeJs("window[$0].removeItem($1)", storage.toString(), key);
    }

    public static void clear() {
        WebStorage.clear(Storage.LOCAL_STORAGE);
    }

    public static void clear(Storage storage) {
        WebStorage.clear(UI.getCurrentOrThrow(), storage);
    }

    public static void clear(UI ui, Storage storage) {
        ui.getPage().executeJs("window[$0].clear()", storage.toString());
    }

    public static void getItem(String key, Callback callback) {
        WebStorage.getItem(Storage.LOCAL_STORAGE, key, callback);
    }

    public static void getItem(Storage storage, String key, Callback callback) {
        WebStorage.getItem(UI.getCurrentOrThrow(), storage, key, callback);
    }

    public static void getItem(UI ui, Storage storage, String key, Callback callback) {
        WebStorage.requestItem(ui, storage, key).then(String.class, callback::onValueDetected, s -> {
            LoggerFactory.getLogger((String)WebStorage.class.getName()).debug("Error while getting value for key '{}' from storage '{}': {}", new Object[]{key, storage, s});
            callback.onValueDetected(null);
        });
    }

    public static CompletableFuture<String> getItem(String key) {
        return WebStorage.getItem(Storage.LOCAL_STORAGE, key);
    }

    public static CompletableFuture<String> getItem(Storage storage, String key) {
        return WebStorage.getItem(UI.getCurrentOrThrow(), storage, key);
    }

    public static CompletableFuture<String> getItem(UI ui, Storage storage, String key) {
        return WebStorage.requestItem(ui, storage, key).toCompletableFuture(String.class);
    }

    private static PendingJavaScriptResult requestItem(UI ui, Storage storage, String key) {
        return ui.getPage().executeJs("return window[$0].getItem($1);", storage.toString(), key);
    }

    public static enum Storage {
        LOCAL_STORAGE,
        SESSION_STORAGE;


        public String toString() {
            if (LOCAL_STORAGE == this) {
                return "localStorage";
            }
            return "sessionStorage";
        }
    }

    @FunctionalInterface
    public static interface Callback
    extends Serializable {
        public void onValueDetected(String var1);
    }
}

