/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import java.io.IOException;

class UploadFileSizeLimitExceededException
extends IOException {
    private final String fileName;
    private final long actualSize;
    private final long permittedSize;

    public UploadFileSizeLimitExceededException(String fileName, long actualSize, long permittedSize) {
        super(String.format("File '%s' size (%d bytes) exceeds the permitted maximum (%d bytes)", fileName, actualSize, permittedSize));
        this.fileName = fileName;
        this.actualSize = actualSize;
        this.permittedSize = permittedSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getActualSize() {
        return this.actualSize;
    }

    public long getPermittedSize() {
        return this.permittedSize;
    }
}

