/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.FocusOption;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutRegistration;
import com.vaadin.flow.dom.Element;
import tools.jackson.databind.node.ObjectNode;

public interface Focusable<T extends Component>
extends HasElement,
BlurNotifier<T>,
FocusNotifier<T>,
HasEnabled {
    default public void setTabIndex(int tabIndex) {
        this.getElement().setAttribute("tabindex", String.valueOf(tabIndex));
    }

    default public int getTabIndex() {
        String attribute = this.getElement().getAttribute("tabindex");
        if (attribute == null || attribute.isEmpty()) {
            throw new IllegalStateException("tabindex attribute is empty on element " + this.getElement().getTag());
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (Exception e) {
            throw new IllegalStateException("tabindex attribute could not be parsed on element " + this.getElement().getTag() + ": " + attribute);
        }
    }

    default public void focus(FocusOption ... options) {
        Element element = this.getElement();
        ObjectNode json = FocusOption.buildOptions(options);
        if (json == null) {
            element.executeJs("setTimeout(function(){$0.focus()},0)", element);
        } else {
            element.executeJs("setTimeout(function(){$0.focus($1)},0)", element, json);
        }
    }

    default public void blur() {
        this.getElement().callJsFunction("blur", new Object[0]);
    }

    default public ShortcutRegistration addFocusShortcut(Key key, KeyModifier ... keyModifiers) {
        if (!(this instanceof Component)) {
            throw new IllegalStateException(String.format("The class '%s' doesn't extend '%s'. Make your implementation for the method '%s'.", this.getClass().getName(), Component.class.getSimpleName(), "addFocusShortcut(Key, KeyModifier...)"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Parameter '%s' must not be null!", "key"));
        }
        Component thisComponent = (Component)((Object)this);
        return new ShortcutRegistration((Component)((Object)this), () -> new Component[]{thisComponent.getUI().get()}, event -> this.focus(new FocusOption[0]), key).withModifiers(keyModifiers);
    }
}

