/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.Pair;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.NoInputStreamException;
import com.vaadin.flow.server.NoOutputStreamException;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.UploadException;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.MultipartConfigurationException;
import com.vaadin.flow.server.communication.TransferUtil;
import com.vaadin.flow.server.communication.UploadFileCountLimitExceededException;
import com.vaadin.flow.server.communication.UploadFileSizeLimitExceededException;
import com.vaadin.flow.server.communication.UploadSizeLimitExceededException;
import com.vaadin.flow.server.communication.streaming.StreamingEndEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingErrorEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingProgressEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingStartEventImpl;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReceiverHandler
implements Serializable {
    private static final int MAX_UPLOAD_BUFFER_SIZE = 4096;
    public static final int DEFAULT_STREAMING_PROGRESS_EVENT_INTERVAL_MS = 500;
    private long requestSizeMax = -1L;
    private long fileSizeMax = -1L;
    private long fileCountMax = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamReceiver streamReceiver, String uiId, String securityKey) throws IOException {
        StateNode source;
        session.lock();
        try {
            String secKey = streamReceiver.getId();
            if (secKey == null || !MessageDigest.isEqual(secKey.getBytes(StandardCharsets.UTF_8), securityKey.getBytes(StandardCharsets.UTF_8))) {
                StreamReceiverHandler.getLogger().warn("Received incoming stream with faulty security key.");
                return;
            }
            UI ui = session.getUIById(Integer.parseInt(uiId));
            UI.setCurrent(ui);
            source = streamReceiver.getNode();
        }
        finally {
            session.unlock();
        }
        try {
            if (this.isMultipartUpload(request)) {
                this.doHandleMultipartFileUpload(session, request, response, streamReceiver, source);
            } else {
                this.doHandleXhrFilePost(session, request, response, streamReceiver, source, request.getContentLengthLong());
            }
        }
        finally {
            UI.setCurrent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHandleMultipartFileUpload(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamReceiver streamReceiver, StateNode owner) throws IOException {
        boolean success = false;
        try {
            success = this.handleMultipartFileUploadFromParts(session, request, streamReceiver, owner);
        }
        catch (IOException exception) {
            StreamReceiverHandler.getLogger().warn("IO Exception during file upload, fired as StreamingErrorEvent", (Throwable)exception);
        }
        catch (Exception exception) {
            session.lock();
            try {
                session.getErrorHandler().error(new ErrorEvent(exception));
            }
            finally {
                session.unlock();
            }
        }
        this.sendUploadResponse(response, success);
    }

    private boolean handleMultipartFileUploadFromParts(VaadinSession session, VaadinRequest request, StreamReceiver streamReceiver, StateNode owner) throws IOException {
        boolean success = true;
        try {
            Collection<Part> parts = this.getParts(request);
            if (parts.isEmpty()) {
                StreamReceiverHandler.getLogger().warn("Multipart request has no parts");
                return false;
            }
            this.validateUploadLimits(request, parts);
            for (Part part : parts) {
                boolean partSuccess = this.handleStream(session, streamReceiver, owner, part);
                success = success && partSuccess;
            }
        }
        catch (UploadFileCountLimitExceededException | UploadFileSizeLimitExceededException | UploadSizeLimitExceededException e) {
            String limitInfoStr = "{} limit exceeded. To increase the limit extend StreamRequestHandler, override {} method and provide a higher limit. The extended class needs to be added to request handlers with ServiceInitEvent::addRequestHandler in an extension of VaadinServiceInitListener.";
            if (e instanceof UploadSizeLimitExceededException) {
                StreamReceiverHandler.getLogger().warn(limitInfoStr, (Object)"Request size", (Object)"getRequestSizeMax");
            } else if (e instanceof UploadFileSizeLimitExceededException) {
                UploadFileSizeLimitExceededException fileSizeException = (UploadFileSizeLimitExceededException)e;
                StreamReceiverHandler.getLogger().warn(limitInfoStr + " File: {}", new Object[]{"File size", "getFileSizeMax", fileSizeException.getFileName()});
            } else if (e instanceof UploadFileCountLimitExceededException) {
                StreamReceiverHandler.getLogger().warn(limitInfoStr, (Object)"File count", (Object)"getFileCountMax");
            }
            success = false;
            StreamReceiverHandler.getLogger().warn("File upload failed.", (Throwable)e);
        }
        catch (Exception e) {
            success = false;
            StreamReceiverHandler.getLogger().warn("File upload failed.", (Throwable)e);
        }
        return success;
    }

    private boolean handleStream(VaadinSession session, StreamReceiver streamReceiver, StateNode owner, Part part) throws IOException {
        String name = part.getSubmittedFileName();
        InputStream stream = part.getInputStream();
        try {
            return this.handleFileUploadValidationAndData(session, stream, streamReceiver, name, part.getContentType(), part.getSize(), owner);
        }
        catch (UploadException e) {
            session.getErrorHandler().error(new ErrorEvent(e));
            return false;
        }
    }

    protected void doHandleXhrFilePost(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamReceiver streamReceiver, StateNode owner, long contentLength) throws IOException {
        String filename = TransferUtil.extractFilenameFromXhrRequest(request);
        String mimeType = TransferUtil.extractContentTypeFromXhrRequest(request);
        InputStream stream = request.getInputStream();
        boolean success = false;
        try {
            success = this.handleFileUploadValidationAndData(session, stream, streamReceiver, filename, mimeType, contentLength, owner);
        }
        catch (UploadException e) {
            session.getErrorHandler().error(new ErrorEvent(e));
        }
        this.sendUploadResponse(response, success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleFileUploadValidationAndData(VaadinSession session, InputStream inputStream, StreamReceiver streamReceiver, String filename, String mimeType, long contentLength, StateNode node) throws UploadException {
        block20: {
            boolean bl;
            block19: {
                session.lock();
                try {
                    if (node == null) {
                        throw new UploadException("File upload ignored because the node for the stream variable was not found");
                    }
                    if (!node.isAttached()) {
                        throw new UploadException("Warning: file upload ignored for " + node.getId() + " because the component was disabled");
                    }
                }
                finally {
                    session.unlock();
                }
                InputStream handledStream = inputStream;
                try {
                    Pair<Boolean, UploadStatus> result = this.streamToReceiver(session, handledStream, streamReceiver, filename, mimeType, contentLength);
                    if (result.getFirst().booleanValue()) {
                        this.cleanStreamVariable(session, streamReceiver);
                    }
                    boolean bl2 = bl = result.getSecond() == UploadStatus.OK;
                    if (handledStream == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (handledStream != null) {
                            try {
                                handledStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        StreamReceiverHandler.getLogger().debug("Exception closing inputStream", (Throwable)ioe);
                        break block20;
                    }
                    catch (UploadException e) {
                        session.lock();
                        try {
                            session.getErrorHandler().error(new ErrorEvent(e));
                            break block20;
                        }
                        finally {
                            session.unlock();
                        }
                    }
                }
                handledStream.close();
            }
            return bl;
        }
        return false;
    }

    protected int getProgressEventInterval() {
        return 500;
    }

    static void tryToCloseStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ioe) {
            StreamReceiverHandler.getLogger().debug("Exception closing stream", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUploadResponse(VaadinResponse response, boolean success) throws IOException {
        block10: {
            response.setContentType("text/html; charset=utf-8");
            if (success) {
                try (OutputStream out = response.getOutputStream();){
                    PrintWriter outWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
                    try {
                        outWriter.print("<html><body>download handled</body></html>");
                        break block10;
                    }
                    finally {
                        outWriter.flush();
                    }
                }
            }
            response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
        }
    }

    private void cleanStreamVariable(VaadinSession session, StreamReceiver streamReceiver) {
        session.lock();
        try {
            session.getResourceRegistry().unregisterResource(streamReceiver);
        }
        finally {
            session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Boolean, UploadStatus> streamToReceiver(VaadinSession session, InputStream in, StreamReceiver streamReceiver, String filename, String type, long contentLength) throws UploadException {
        StreamVariable streamVariable = streamReceiver.getStreamVariable();
        if (streamVariable == null) {
            throw new IllegalStateException("StreamVariable for the post not found");
        }
        OutputStream out = null;
        long totalBytes = 0L;
        StreamingStartEventImpl startedEvent = new StreamingStartEventImpl(filename, type, contentLength);
        boolean success = false;
        try {
            int bytesReadToBuffer;
            boolean listenProgress;
            session.lock();
            try {
                streamVariable.streamingStarted(startedEvent);
                out = streamVariable.getOutputStream();
                listenProgress = streamVariable.listenProgress();
            }
            finally {
                session.unlock();
            }
            if (out == null) {
                throw new NoOutputStreamException();
            }
            if (null == in) {
                throw new NoInputStreamException();
            }
            byte[] buffer = new byte[4096];
            long lastStreamingEvent = 0L;
            do {
                if ((bytesReadToBuffer = in.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesReadToBuffer);
                    totalBytes += (long)bytesReadToBuffer;
                }
                if (listenProgress) {
                    StreamingProgressEventImpl progressEvent = new StreamingProgressEventImpl(filename, type, contentLength, totalBytes);
                    lastStreamingEvent = this.updateProgress(session, streamVariable, progressEvent, lastStreamingEvent, bytesReadToBuffer);
                }
                if (!streamVariable.isInterrupted()) continue;
                throw new UploadInterruptedException();
            } while (bytesReadToBuffer > 0);
            out.close();
            StreamingEndEventImpl event = new StreamingEndEventImpl(filename, type, totalBytes);
            session.lock();
            try {
                streamVariable.streamingFinished(event);
            }
            finally {
                session.unlock();
            }
            success = true;
        }
        catch (UploadInterruptedException | IOException e) {
            this.onStreamingFailed(session, filename, type, contentLength, streamVariable, out, totalBytes, e);
        }
        catch (Exception e) {
            this.onStreamingFailed(session, filename, type, contentLength, streamVariable, out, totalBytes, e);
            throw new UploadException(e);
        }
        return new Pair<Boolean, UploadStatus>(startedEvent.isDisposed(), success ? UploadStatus.OK : UploadStatus.ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStreamingFailed(VaadinSession session, String filename, String type, long contentLength, StreamVariable streamVariable, OutputStream out, long totalBytes, Exception exception) {
        StreamReceiverHandler.tryToCloseStream(out);
        session.lock();
        try {
            streamVariable.streamingFailed(new StreamingErrorEventImpl(filename, type, contentLength, totalBytes, exception));
        }
        finally {
            session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateProgress(VaadinSession session, StreamVariable streamVariable, StreamingProgressEventImpl progressEvent, long lastStreamingEvent, int bytesReadToBuffer) {
        long now = System.currentTimeMillis();
        if (lastStreamingEvent + (long)this.getProgressEventInterval() <= now || bytesReadToBuffer <= 0) {
            session.lock();
            try {
                streamVariable.onProgress(progressEvent);
            }
            finally {
                session.unlock();
            }
            return now;
        }
        return lastStreamingEvent;
    }

    protected boolean isMultipartUpload(VaadinRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!"POST".equalsIgnoreCase(httpRequest.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().startsWith("multipart/");
    }

    protected Collection<Part> getParts(VaadinRequest request) throws Exception {
        try {
            return ((HttpServletRequest)request).getParts();
        }
        catch (ServletException | IllegalStateException e) {
            throw new MultipartConfigurationException(e);
        }
    }

    protected void validateUploadLimits(VaadinRequest request, Collection<Part> parts) throws UploadSizeLimitExceededException, UploadFileSizeLimitExceededException, UploadFileCountLimitExceededException {
        if (this.fileCountMax > -1L && (long)parts.size() > this.fileCountMax) {
            throw new UploadFileCountLimitExceededException(parts.size(), this.fileCountMax);
        }
        long contentLength = request.getContentLengthLong();
        if (this.requestSizeMax > -1L && contentLength > this.requestSizeMax) {
            throw new UploadSizeLimitExceededException(contentLength, this.requestSizeMax);
        }
        if (this.fileSizeMax > -1L) {
            for (Part part : parts) {
                long size = part.getSize();
                if (size <= this.fileSizeMax) continue;
                throw new UploadFileSizeLimitExceededException(part.getSubmittedFileName(), size, this.fileSizeMax);
            }
        }
    }

    public void setRequestSizeMax(long requestSizeMax) {
        this.requestSizeMax = requestSizeMax;
    }

    public void setFileSizeMax(long fileSizeMax) {
        this.fileSizeMax = fileSizeMax;
    }

    public void setFileCountMax(long fileCountMax) {
        this.fileCountMax = fileCountMax;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StreamReceiverHandler.class.getName());
    }

    static enum UploadStatus {
        OK,
        ERROR;

    }

    public static class UploadInterruptedException
    extends Exception {
        public UploadInterruptedException() {
            super("Upload interrupted by other thread");
        }
    }
}

