/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.internal.JacksonUtils;
import java.io.Serializable;
import java.util.Locale;
import tools.jackson.databind.node.ObjectNode;

public interface ScrollIntoViewOption
extends Serializable {
    public static ObjectNode buildOptions(ScrollIntoViewOption ... options) {
        Behavior behavior = null;
        Block block = null;
        Inline inline = null;
        for (ScrollIntoViewOption option : options) {
            if (option instanceof Behavior) {
                behavior = (Behavior)option;
                continue;
            }
            if (option instanceof Block) {
                block = (Block)option;
                continue;
            }
            if (!(option instanceof Inline)) continue;
            inline = (Inline)option;
        }
        if (behavior == null && block == null && inline == null) {
            return null;
        }
        ObjectNode json = JacksonUtils.createObjectNode();
        if (behavior != null) {
            json.put("behavior", behavior.getValue());
        }
        if (block != null) {
            json.put("block", block.getValue());
        }
        if (inline != null) {
            json.put("inline", inline.getValue());
        }
        return json;
    }

    public static enum Behavior implements ScrollIntoViewOption
    {
        AUTO,
        SMOOTH;


        public String getValue() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class Block
    implements ScrollIntoViewOption {
        public static final Block START = new Block("start");
        public static final Block CENTER = new Block("center");
        public static final Block END = new Block("end");
        public static final Block NEAREST = new Block("nearest");
        private final String value;

        private Block(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class Inline
    implements ScrollIntoViewOption {
        public static final Inline START = new Inline("start");
        public static final Inline CENTER = new Inline("center");
        public static final Inline END = new Inline("end");
        public static final Inline NEAREST = new Inline("nearest");
        private final String value;

        private Inline(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

