/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.shared.ui;

import com.vaadin.flow.shared.ui.LoadMode;
import elemental.json.Json;
import elemental.json.JsonObject;
import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;

public class Dependency
implements Serializable {
    public static final String KEY_URL = "url";
    public static final String KEY_TYPE = "type";
    public static final String KEY_LOAD_MODE = "mode";
    public static final String KEY_CONTENTS = "contents";
    public static final String KEY_ID = "id";
    private final Type type;
    private final String url;
    private final LoadMode loadMode;
    private String id;

    public Dependency(Type type, String url, LoadMode loadMode) {
        this(type, url, loadMode, null);
    }

    public Dependency(Type type, String url, LoadMode loadMode, String id) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this.type = Objects.requireNonNull(type);
        this.url = url;
        this.loadMode = loadMode;
        this.id = id;
    }

    public Dependency(Type type, String expression) {
        this(type, expression, LoadMode.LAZY);
    }

    public String getUrl() {
        return this.url;
    }

    public Type getType() {
        return this.type;
    }

    public LoadMode getLoadMode() {
        return this.loadMode;
    }

    public String getId() {
        return this.id;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = Json.createObject();
        jsonObject.put(KEY_URL, this.url);
        jsonObject.put(KEY_TYPE, this.type.name());
        jsonObject.put(KEY_LOAD_MODE, this.loadMode.name());
        if (this.id != null) {
            jsonObject.put(KEY_ID, this.id);
        }
        return jsonObject;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.url, this.loadMode, this.id});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependency that = (Dependency)o;
        return this.type == that.type && this.loadMode == that.loadMode && Objects.equals(this.url, that.url) && Objects.equals(this.id, that.id);
    }

    public String toString() {
        return "Dependency [type=" + String.valueOf((Object)this.type) + ", url=" + this.url + ", loadMode=" + String.valueOf((Object)this.loadMode) + ", id=" + this.id + "]";
    }

    public static enum Type {
        STYLESHEET,
        JAVASCRIPT,
        JS_MODULE,
        DYNAMIC_IMPORT;


        public static boolean contains(String value) {
            return Stream.of(Type.values()).anyMatch(enumValue -> enumValue.toString().equals(value));
        }
    }
}

