/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.streams;

import com.vaadin.flow.server.HttpStatusCode;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.streams.AbstractDownloadHandler;
import com.vaadin.flow.server.streams.DownloadEvent;
import com.vaadin.flow.server.streams.TransferContext;
import com.vaadin.flow.server.streams.TransferUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileDownloadHandler
extends AbstractDownloadHandler<FileDownloadHandler> {
    private final File file;
    private final String fileNameOverride;

    public FileDownloadHandler(File file) {
        this(file, null);
    }

    public FileDownloadHandler(File file, String fileNameOverride) {
        this.file = file;
        this.fileNameOverride = fileNameOverride;
    }

    @Override
    public void handleDownloadRequest(DownloadEvent downloadEvent) throws IOException {
        this.setTransferUI(downloadEvent.getUI());
        VaadinResponse response = downloadEvent.getResponse();
        try (OutputStream outputStream = downloadEvent.getOutputStream();
             FileInputStream inputStream = new FileInputStream(this.file);){
            String resourceName = this.getUrlPostfix();
            if (this.isInline()) {
                downloadEvent.inline(resourceName);
            } else {
                downloadEvent.setFileName(resourceName);
            }
            downloadEvent.setContentType(this.getContentType(resourceName, response));
            downloadEvent.setContentLength(this.file.length());
            TransferUtil.transfer(inputStream, outputStream, this.getTransferContext(downloadEvent), this.getListeners());
        }
        catch (IOException ioe) {
            response.setStatus(HttpStatusCode.INTERNAL_SERVER_ERROR.getCode());
            downloadEvent.setException(ioe);
            this.notifyError(downloadEvent, ioe);
            throw ioe;
        }
    }

    @Override
    public String getUrlPostfix() {
        if (this.fileNameOverride != null) {
            return this.fileNameOverride;
        }
        return this.file.getName();
    }

    @Override
    protected TransferContext getTransferContext(DownloadEvent transferEvent) {
        return new TransferContext(transferEvent.getRequest(), transferEvent.getResponse(), transferEvent.getSession(), this.getUrlPostfix(), transferEvent.getOwningElement(), this.file.length(), transferEvent.getException());
    }
}

