/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.FileIOUtils;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ObjectNode;

public class TaskGenerateTsConfig
extends AbstractTaskClientGenerator {
    protected static boolean warningEmitted = false;
    private static final String COMPILER_OPTIONS = "compilerOptions";
    static final String TSCONFIG_JSON = "tsconfig.json";
    private static final String OLD_VERSION_KEY = "flow_version";
    private static final String VERSION = "_version";
    private static final String ES_TARGET_VERSION = "target";
    private static final String TSCONFIG_JSON_OLDER_VERSIONS_TEMPLATE = "tsconfig-%s.json";
    private static final String[] tsconfigVersions = new String[]{"latest", "v23.3.0.1", "v23.3.0", "v23.2", "v23.1", "v22", "v14", "osgi", "v23.3.4", "v23.3.4-hilla", "es2020"};
    static final String ERROR_MESSAGE = "\n**************************************************************************\n*  TypeScript config file 'tsconfig.json' has been updated to the latest *\n*  version by Vaadin. Please verify that the updated 'tsconfig.json'     *\n*  file contains configuration needed for your project (add any missing  *\n*  parts from the old file if necessary) and restart the application.    *\n*  Old configuration is stored as a '.bak' file.                         *\n**************************************************************************\n\n";
    private Options options;

    TaskGenerateTsConfig(Options options) {
        this.options = options;
    }

    @Override
    protected String getFileContent() throws IOException {
        return this.getFileContentForVersion("latest");
    }

    private String getFileContentForVersion(String vaadinVersion) throws IOException {
        String fileName = "latest".equals(vaadinVersion) ? TSCONFIG_JSON : String.format(TSCONFIG_JSON_OLDER_VERSIONS_TEMPLATE, vaadinVersion);
        try (InputStream tsConfStream = this.getClass().getResourceAsStream(fileName);){
            String config = IOUtils.toString((InputStream)tsConfStream, (Charset)StandardCharsets.UTF_8);
            String string = config = config.replaceAll("%FRONTEND%", this.options.getNpmFolder().toPath().relativize(this.options.getFrontendDirectory().toPath()).toString().replaceAll("\\\\", "/"));
            return string;
        }
    }

    @Override
    public void execute() throws ExecutionFailedException {
        if (this.shouldGenerate()) {
            super.execute();
        } else {
            this.overrideIfObsolete();
            this.ensureTarget(this.getDefaultEsTargetVersion());
        }
    }

    private void ensureTarget(String esVersion) {
        try {
            File projectTsconfig = new File(this.options.getNpmFolder(), TSCONFIG_JSON);
            String current = FileUtils.readFileToString((File)projectTsconfig, (Charset)StandardCharsets.UTF_8);
            String currentEsVersion = this.getEsTargetVersion(current);
            if (TaskGenerateTsConfig.isOlder(currentEsVersion, esVersion)) {
                current = current.replace(currentEsVersion, esVersion);
                FileIOUtils.writeIfChanged(projectTsconfig, current);
            }
        }
        catch (Exception e) {
            TaskGenerateTsConfig.log().debug("Unable to modify target version in tsconfig.json", (Throwable)e);
        }
    }

    static boolean isOlder(String esVersion1, String esVersion2) {
        if (esVersion1.startsWith("es") && esVersion2.startsWith("es")) {
            return esVersion1.compareTo(esVersion2) < 0;
        }
        return !esVersion1.equals(esVersion2);
    }

    private String getDefaultEsTargetVersion() throws ExecutionFailedException {
        try {
            String defaultTsConfig = this.getFileContent();
            return this.getEsTargetVersion(defaultTsConfig);
        }
        catch (Exception e) {
            throw new ExecutionFailedException("Error finding default es target value", e);
        }
    }

    private String getEsTargetVersion(String tsConfig) {
        ObjectNode parsed = this.parseTsConfig(tsConfig);
        return parsed.get(COMPILER_OPTIONS).get(ES_TARGET_VERSION).asString();
    }

    private ObjectNode parseTsConfig(String tsConfig) {
        String json = tsConfig.replaceAll("//.*", "");
        return JacksonUtils.readTree(json);
    }

    @Override
    protected File getGeneratedFile() {
        return new File(this.options.getNpmFolder(), TSCONFIG_JSON);
    }

    @Override
    protected boolean shouldGenerate() {
        return !this.getGeneratedFile().exists();
    }

    private void overrideIfObsolete() {
        try {
            Object templateVersion;
            ObjectNode projectTsConfigContent;
            File projectTsConfigFile = new File(this.options.getNpmFolder().getPath(), TSCONFIG_JSON);
            String projectTsConfigAsString = FileUtils.readFileToString((File)projectTsConfigFile, (Charset)StandardCharsets.UTF_8);
            try {
                projectTsConfigContent = this.parseTsConfig(projectTsConfigAsString);
            }
            catch (Exception e) {
                TaskGenerateTsConfig.log().error("Unable to parse tsconfig.json", (Throwable)e);
                return;
            }
            String latestTsConfigTemplate = this.getFileContent();
            ObjectNode latestTsConfigTemplateJson = this.parseTsConfig(latestTsConfigTemplate);
            String projectTsConfigVersion = this.getConfigVersion((JsonNode)projectTsConfigContent);
            if (projectTsConfigVersion != null && ((String)(templateVersion = this.getConfigVersion((JsonNode)latestTsConfigTemplateJson))).equals(projectTsConfigVersion)) {
                return;
            }
            for (String tsconfigVersion : tsconfigVersions) {
                String oldTsConfigContent = this.getFileContentForVersion(tsconfigVersion);
                ObjectNode tsConfigTemplateJson = this.parseTsConfig(oldTsConfigContent);
                if (!this.tsConfigsEqual(tsConfigTemplateJson, projectTsConfigContent)) continue;
                FileIOUtils.writeIfChanged(projectTsConfigFile, latestTsConfigTemplate);
                return;
            }
            File backupFile = File.createTempFile(projectTsConfigFile.getName() + ".", ".bak", projectTsConfigFile.getParentFile());
            FileIOUtils.writeIfChanged(backupFile, projectTsConfigAsString);
            FileIOUtils.writeIfChanged(projectTsConfigFile, latestTsConfigTemplate);
            if (!warningEmitted) {
                TaskGenerateTsConfig.log().warn(ERROR_MESSAGE);
                warningEmitted = true;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String getConfigVersion(JsonNode projectTsConfigContent) {
        if (projectTsConfigContent.has(VERSION)) {
            return projectTsConfigContent.get(VERSION).asString();
        }
        if (projectTsConfigContent.has(OLD_VERSION_KEY)) {
            return projectTsConfigContent.get(OLD_VERSION_KEY).asString();
        }
        return null;
    }

    private boolean tsConfigsEqual(ObjectNode template, ObjectNode projectTsConfig) {
        if (template.has(COMPILER_OPTIONS)) {
            ((ObjectNode)template.get(COMPILER_OPTIONS)).remove(ES_TARGET_VERSION);
        }
        if (projectTsConfig.has(COMPILER_OPTIONS)) {
            ((ObjectNode)projectTsConfig.get(COMPILER_OPTIONS)).remove(ES_TARGET_VERSION);
        }
        template.remove(VERSION);
        projectTsConfig.remove(VERSION);
        return this.removeWhiteSpaces(template.toString()).equals(this.removeWhiteSpaces(projectTsConfig.toString()));
    }

    private String removeWhiteSpaces(String content) {
        return content.replaceAll("\\s", "");
    }
}

