/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.NodeFeatureChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.BooleanNode;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.node.NumericNode;
import tools.jackson.databind.node.ObjectNode;
import tools.jackson.databind.node.StringNode;
import tools.jackson.databind.node.ValueNode;

public class MapPutChange
extends NodeFeatureChange {
    private final String key;
    private final Object value;

    public MapPutChange(NodeFeature map, String key, Object value) {
        super(map);
        assert (key != null);
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected void populateJson(ObjectNode json, ConstantPool constantPool) {
        json.put("type", "put");
        json.put("key", this.key);
        super.populateJson(json, constantPool);
        Object object = this.value;
        if (object instanceof StateNode) {
            StateNode node = (StateNode)object;
            json.set("nodeValue", JacksonUtils.createNode(node.getId()));
        } else {
            object = this.value;
            if (object instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)object;
                json.set("value", JacksonCodec.encodeWithConstantPool(node, constantPool));
            } else if (this.value instanceof NullNode) {
                json.set("value", (JsonNode)((NullNode)this.value));
            } else {
                object = this.value;
                if (object instanceof NumericNode) {
                    NumericNode node = (NumericNode)object;
                    json.set("value", JacksonCodec.encodeWithConstantPool(node, constantPool));
                } else {
                    object = this.value;
                    if (object instanceof BooleanNode) {
                        BooleanNode node = (BooleanNode)object;
                        json.set("value", JacksonCodec.encodeWithConstantPool(node, constantPool));
                    } else {
                        object = this.value;
                        if (object instanceof StringNode) {
                            StringNode node = (StringNode)object;
                            json.set("value", JacksonCodec.encodeWithConstantPool(node, constantPool));
                        } else {
                            object = this.value;
                            if (object instanceof ValueNode) {
                                ValueNode node = (ValueNode)object;
                                json.set("value", JacksonCodec.encodeWithConstantPool(node, constantPool));
                            } else {
                                object = this.value;
                                if (object instanceof ArrayNode) {
                                    ArrayNode node = (ArrayNode)object;
                                    json.set("value", (JsonNode)((ArrayNode)JacksonCodec.encodeWithConstantPool(node, constantPool)));
                                } else {
                                    json.set("value", JacksonCodec.encodeWithConstantPool(this.value, constantPool));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

