/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.change;

import com.vaadin.flow.internal.ConstantPool;
import com.vaadin.flow.internal.JacksonCodec;
import com.vaadin.flow.internal.JacksonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.nodefeature.NodeList;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;
import tools.jackson.databind.node.ObjectNode;

public class ListAddChange<T extends Serializable>
extends AbstractListChange<T> {
    private final List<? extends T> newItems;
    private final boolean nodeValues;

    public ListAddChange(NodeList<T> list, boolean nodeValues, int index, List<? extends T> newItems) {
        super(list, index);
        this.newItems = newItems;
        this.nodeValues = nodeValues;
    }

    public List<? extends T> getNewItems() {
        return Collections.unmodifiableList(this.newItems);
    }

    public boolean isEmpty() {
        return this.newItems.isEmpty();
    }

    public ListAddChange<T> copy(List<? extends T> items) {
        return new ListAddChange<T>(this.getNodeList(), this.nodeValues, this.getIndex(), items);
    }

    @Override
    public ListAddChange<T> copy(int indx) {
        return new ListAddChange<T>(this.getNodeList(), this.nodeValues, indx, this.newItems);
    }

    @Override
    protected void populateJson(ObjectNode json, ConstantPool constantPool) {
        Function<Object, JsonNode> mapper;
        String addKey;
        json.put("type", "splice");
        super.populateJson(json, constantPool);
        json.put("index", this.getIndex());
        if (this.nodeValues) {
            addKey = "addNodes";
            mapper = item -> JacksonUtils.createNode(((StateNode)item).getId());
        } else {
            addKey = "add";
            mapper = item -> JacksonCodec.encodeWithConstantPool(item, constantPool);
        }
        ArrayNode newItemsJson = this.newItems.stream().map(mapper).collect(JacksonUtils.asArray());
        json.set(addKey, (JsonNode)newItemsJson);
    }

    public void removeItem(T item) {
        assert (this.newItems.size() > 1) : "Item list can't be empty after item removal";
        this.newItems.remove(item);
    }
}

