/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.di.Lookup;
import com.vaadin.flow.di.ResourceProvider;
import com.vaadin.flow.server.HandlerHelper;
import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class UnsupportedBrowserHandler
implements RequestHandler {
    private static final String BROWSER_TOO_OLD_HTML = "browser-too-old.html";

    @Override
    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        URL applicationBrowserTooOldPage;
        ResourceProvider resourceProvider;
        if (!HandlerHelper.isRequestType(request, HandlerHelper.RequestType.BROWSER_TOO_OLD)) {
            return false;
        }
        response.setContentType("text/html; charset=utf-8");
        Lookup lookup = session.getService().getContext().getAttribute(Lookup.class);
        if (lookup != null && (resourceProvider = lookup.lookup(ResourceProvider.class)) != null && (applicationBrowserTooOldPage = resourceProvider.getApplicationResource(BROWSER_TOO_OLD_HTML)) != null) {
            IOUtils.copy((URL)applicationBrowserTooOldPage, (OutputStream)response.getOutputStream());
            return true;
        }
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream(BROWSER_TOO_OLD_HTML), (OutputStream)response.getOutputStream());
        return true;
    }
}

