/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.MapPutChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.shared.util.UniqueSerializable;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;

public abstract class NodeValue<T extends Serializable>
extends NodeFeature {
    private static final UniqueSerializable NULL_MARKER = new UniqueSerializable(){};
    private T value;
    private boolean isPopulated;

    public NodeValue(StateNode node) {
        super(node);
        this.isPopulated = !node.isReportedFeature(this.getClass());
    }

    protected abstract String getKey();

    protected void setValue(T value) {
        if (!Objects.equals(value, this.value)) {
            this.markAsDirty();
            this.value = value;
        }
    }

    private void markAsDirty() {
        this.getNode().markAsDirty();
        this.getNode().getChangeTracker(this, () -> this.value != null ? this.value : NULL_MARKER);
    }

    protected T getValue() {
        return this.value;
    }

    @Override
    public void collectChanges(Consumer<NodeChange> collector) {
        Serializable originalValue = this.getNode().getChangeTracker(this, () -> null);
        assert (originalValue != null);
        if (originalValue == NULL_MARKER) {
            originalValue = null;
        }
        if (!Objects.equals(originalValue, this.value)) {
            collector.accept(new MapPutChange(this, this.getKey(), this.value));
        } else if (!this.isPopulated) {
            collector.accept(new EmptyChange(this));
        }
        this.isPopulated = true;
    }

    @Override
    public void generateChangesFromEmpty() {
        this.getNode().getChangeTracker(this, () -> NULL_MARKER);
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
        if (this.getValue() instanceof StateNode) {
            action.accept((StateNode)this.getValue());
        }
    }
}

