/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.FrontendUtils;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FullDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FrontendDependenciesScanner
extends Serializable {
    public Map<String, String> getPackages();

    public Map<String, String> getDevPackages();

    public Map<String, List<String>> getAssets();

    public Map<String, List<String>> getDevAssets();

    public Map<ChunkInfo, List<String>> getModules();

    public Map<ChunkInfo, List<String>> getModulesDevelopment();

    public Map<ChunkInfo, List<String>> getScripts();

    public Map<ChunkInfo, List<String>> getScriptsDevelopment();

    public Map<ChunkInfo, List<CssData>> getCss();

    public ThemeDefinition getThemeDefinition();

    public AbstractTheme getTheme();

    public Set<String> getClasses();

    public PwaConfiguration getPwaConfiguration();

    public static class FrontendDependenciesScannerFactory {
        @Deprecated
        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents) {
            return this.createScanner(allDependenciesScan, finder, generateEmbeddableWebComponents, null);
        }

        @Deprecated
        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents, FeatureFlags featureFlags) {
            return this.createScanner(allDependenciesScan, finder, generateEmbeddableWebComponents, featureFlags, true);
        }

        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents, FeatureFlags featureFlags, boolean reactEnabled) {
            if (allDependenciesScan) {
                return new FullDependenciesScanner(finder, featureFlags, reactEnabled);
            }
            return new FrontendDependencies(finder, generateEmbeddableWebComponents, featureFlags, reactEnabled);
        }

        @Deprecated
        public FrontendDependenciesScanner createScanner(Options options) {
            boolean reactEnabled = options.isReactEnabled() && FrontendUtils.isReactRouterRequired(options.getFrontendDirectory());
            return this.createScanner(!options.isUseByteCodeScanner(), options.getClassFinder(), options.isGenerateEmbeddableWebComponents(), options.getFeatureFlags(), reactEnabled);
        }
    }
}

