/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.change.AbstractListChange;
import com.vaadin.flow.internal.change.EmptyChange;
import com.vaadin.flow.internal.change.ListAddChange;
import com.vaadin.flow.internal.change.ListClearChange;
import com.vaadin.flow.internal.change.ListRemoveChange;
import com.vaadin.flow.internal.change.NodeChange;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public abstract class NodeList<T extends Serializable>
extends NodeFeature {
    private List<T> values;
    private boolean isRemoveAllCalled;
    private boolean isPopulated;

    protected NodeList(StateNode node) {
        super(node);
        this.isPopulated = !node.isReportedFeature(this.getClass());
    }

    protected int size() {
        this.setAccessed();
        if (this.values == null) {
            return 0;
        }
        return this.values.size();
    }

    private void ensureValues() {
        if (this.values == null) {
            this.values = new ArrayList<T>(1);
        }
    }

    protected T get(int index) {
        this.setAccessed();
        if (this.values == null) {
            throw new IndexOutOfBoundsException();
        }
        return (T)((Serializable)this.values.get(index));
    }

    protected void add(T item) {
        this.ensureValues();
        this.add(this.values.size(), item);
    }

    protected void addAll(Collection<? extends T> items) {
        assert (items != null);
        if (items.isEmpty()) {
            return;
        }
        ArrayList<? extends T> itemsList = new ArrayList<T>(items);
        this.ensureValues();
        int startIndex = this.values.size();
        this.values.addAll(itemsList);
        this.addChange(new ListAddChange<T>(this, this.isNodeValues(), startIndex, itemsList));
    }

    protected void add(int index, T item) {
        this.ensureValues();
        this.values.add(index, item);
        this.addChange(new ListAddChange<T>(this, this.isNodeValues(), index, Collections.singletonList(item)));
    }

    protected T remove(int index) {
        if (this.values == null) {
            throw new IndexOutOfBoundsException();
        }
        Serializable removed = (Serializable)this.values.remove(index);
        this.addChange(new ListRemoveChange<Serializable>(this, index, removed));
        if (this.values.isEmpty()) {
            this.values = null;
        }
        return (T)removed;
    }

    protected List<AbstractListChange<T>> getChangeTracker() {
        return this.getNode().getChangeTracker(this, ArrayList::new);
    }

    private void addChange(AbstractListChange<T> change) {
        this.getNode().markAsDirty();
        if (change instanceof ListRemoveChange) {
            ListRemoveChange removeChange = (ListRemoveChange)change;
            Object item = removeChange.getRemovedItem();
            List<AbstractListChange<T>> tracker = this.getChangeTracker();
            for (int nextChangeIndex = 0; nextChangeIndex < tracker.size(); ++nextChangeIndex) {
                ListAddChange addChange;
                AbstractListChange<T> nextChange = tracker.get(nextChangeIndex);
                if (!(nextChange instanceof ListAddChange) || !(addChange = (ListAddChange)nextChange).getNewItems().contains(item)) continue;
                int indexToCorrect = this.removeFromListAddChange(addChange, item);
                this.reindexChanges(tracker, nextChangeIndex, indexToCorrect);
                return;
            }
        }
        if (change instanceof ListClearChange) {
            this.getChangeTracker().clear();
        }
        this.getChangeTracker().add(change);
    }

    private void reindexChanges(List<AbstractListChange<T>> tracker, int startFrom, int indexToCorrect) {
        for (int nextIndex = startFrom; nextIndex < tracker.size(); ++nextIndex) {
            AbstractListChange<T> listChange = tracker.get(nextIndex);
            if (listChange.getIndex() <= indexToCorrect) continue;
            listChange.setIndex(listChange.getIndex() - 1);
        }
    }

    private int removeFromListAddChange(ListAddChange<T> listAddChange, T item) {
        int indexToCorrect = 0;
        if (listAddChange.getNewItems().size() == 1) {
            this.getChangeTracker().remove(listAddChange);
        } else {
            indexToCorrect = listAddChange.getNewItems().indexOf(item);
            assert (indexToCorrect != -1);
            listAddChange.removeItem(item);
        }
        return indexToCorrect += listAddChange.getIndex();
    }

    private void setAccessed() {
    }

    @Override
    public void collectChanges(Consumer<NodeChange> collector) {
        LinkedList<AbstractListChange<T>> changes = new LinkedList<AbstractListChange<T>>();
        for (AbstractListChange<T> change : this.getChangeTracker()) {
            if (!this.acceptChange(change)) continue;
            changes.add(change);
        }
        if (this.isPopulated) {
            changes.forEach(collector);
        } else {
            if (changes.isEmpty()) {
                collector.accept(new EmptyChange(this));
            } else {
                changes.forEach(collector);
            }
            this.isPopulated = true;
        }
    }

    private boolean acceptChange(AbstractListChange<T> change) {
        if (change == null) {
            return false;
        }
        if (change instanceof ListAddChange) {
            return !((ListAddChange)change).isEmpty();
        }
        return true;
    }

    @Override
    public void forEachChild(Consumer<StateNode> action) {
    }

    @Override
    public void generateChangesFromEmpty() {
        if (this.isRemoveAllCalled) {
            this.addChange(new ListClearChange(this));
        }
        if (this.values != null) {
            assert (!this.values.isEmpty());
            this.getChangeTracker().add(new ListAddChange<T>(this, this.isNodeValues(), 0, new ArrayList<T>(this.values)));
        } else if (!this.isPopulated) {
            this.getChangeTracker();
        }
    }

    protected boolean isNodeValues() {
        return false;
    }

    protected void clear() {
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
        this.isRemoveAllCalled = true;
        this.addChange(new ListClearChange(this));
    }

    protected int indexOf(T value) {
        this.setAccessed();
        if (this.values == null) {
            return -1;
        }
        return this.values.indexOf(value);
    }

    protected Iterator<T> iterator() {
        if (this.values == null) {
            return Collections.emptyList().iterator();
        }
        return new NodeListIterator();
    }

    @Override
    public void onDetach() {
        if (this.isPopulated && this.values == null) {
            this.isPopulated = false;
        }
    }

    private final class NodeListIterator
    implements Iterator<T> {
        private int index = -1;
        private T current;
        private Iterator<T> arrayIterator;

        private NodeListIterator() {
            this.arrayIterator = NodeList.this.values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public T next() {
            ++this.index;
            this.current = (Serializable)this.arrayIterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.arrayIterator.remove();
            NodeList.this.addChange(new ListRemoveChange(NodeList.this, this.index, this.current));
            --this.index;
        }
    }

    protected static abstract class SetView<T extends Serializable>
    extends AbstractSet<T>
    implements Serializable {
        private NodeList<T> nodeList;

        public SetView(NodeList<T> nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public int size() {
            return this.nodeList.size();
        }

        @Override
        public void clear() {
            this.nodeList.clear();
        }

        @Override
        public boolean add(T o) {
            this.validate(o);
            if (this.contains(o)) {
                return false;
            }
            this.nodeList.add(this.size(), o);
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (!this.contains(o)) {
                return false;
            }
            T removedItem = this.nodeList.remove(this.nodeList.indexOf((Serializable)o));
            return removedItem != null;
        }

        protected abstract void validate(T var1);

        @Override
        public boolean contains(Object o) {
            return this.nodeList.indexOf((Serializable)o) != -1;
        }

        @Override
        public Iterator<T> iterator() {
            return this.nodeList.iterator();
        }
    }
}

