/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import java.io.Serializable;

public class ErrorParameter<T extends Exception>
implements Serializable {
    private final T exception;
    private final Exception caughtException;
    private final String customMessage;

    public ErrorParameter(Class<T> parameterType, Exception caughtException) {
        this(parameterType, caughtException, null);
    }

    public ErrorParameter(Class<T> parameterType, Exception caughtException, String customMessage) {
        this.caughtException = caughtException;
        this.customMessage = customMessage;
        this.exception = ErrorParameter.findCauseByType(parameterType, caughtException);
    }

    private static <T extends Exception> T findCauseByType(Class<T> type, Exception exception) {
        if (type.isInstance(exception)) {
            return (T)((Exception)type.cast(exception));
        }
        Throwable cause = exception.getCause();
        if (cause instanceof Exception) {
            return ErrorParameter.findCauseByType(type, (Exception)cause);
        }
        return null;
    }

    public T getException() {
        return this.exception;
    }

    public Exception getCaughtException() {
        return this.caughtException;
    }

    public boolean hasCustomMessage() {
        return this.customMessage != null && !this.customMessage.isEmpty();
    }

    public String getCustomMessage() {
        return this.customMessage == null ? "" : this.customMessage;
    }
}

